﻿//
// Create a Namespace class.
//
// Old usage:
//		functions = _root.Namespace(primitives);
//		definitions = functions.parent;
//		variables = _root.Namespace();
//
// e.g. create own stack frame (inheriting callers')
//		variables = _root.Namespace(variables);
//
import LogoFunction;
class Namespace {

	var parent:Namespace;
	var space:Object;
	
	function Namespace(parent:Namespace) {
		space = {parent:parent};
	}
	
	function getVariable(name:String):Object {
		var val:Object = space[name];
		if(val != null) {
			return val;
		}
		if(parent != null) {
			return parent.getVariable(name);
		}
		return null;
	}
	
	function setVariable(name:String, val:Object):Void {
		space[name] = val;
	}
	
	function getFunction(name:String):LogoFunction {
		return LogoFunction(getVariable(name));
	}
	
	function setFunction(name:String, fn:LogoFunction):Void {
		space[name] = fn;
	}
						 
}
