function Template(name, node)
{
  this.name = name;
  this.root = node;
}

Template.pattern = /#([A-Z][A-Za-z]*) ?/;

Template.initialize = function (node)
{
   var tag, matches;
   var alltags = document.getElementsByTagName('*');

   this.instances = new Array;
   for (var i=0; i<alltags.length; i++)
   {
      tag = alltags.item(i);
      matches = this.pattern.exec(tag.className);
      if (matches) 
      {
        this.instances.push(new Template(matches[1], tag));
      }
   }
}

Template.named = function(name)
{
  for (var i=0; i<this.instances.length; i++)
    if (this.instances[i].name == name)
      return this.instances[i];
  return null;
}

Template.prototype.clone = function()
{
  var clone = this.root.cloneNode(true);
  clone.removeAttribute('style');
  clone.className = clone.className.replace(Template.pattern, '');
  return clone;
};


function Controller() {}

Controller.prototype.pattern = /@([a-z][A-Za-z]*)/;

Controller.prototype.set = function(node, name, value)
{
  if (node.variables == undefined) node.variables = new Object;
  node.variables[name] = value;
}

Controller.prototype.get = function(node, name)
{
  var current = node;
  var result = null;
  while (result == null && current != undefined)
  {
    if (current.variables != undefined && current.variables[name] != undefined)
      result = current.variables[name];
    current = current.parentNode;
  }
  return result;
}

Controller.prototype.installOn = function(root, template)
{
	var self = this;
	if (template)
	{
	  this.root = template.clone();
	  root.parentNode.replaceChild(this.root, root);
	  this.predecessor = root;
	}
	else this.root = root;
  this.expandMacros(this.root);
	this.root.component = this;
  
  window.setTimeout(function() {self.activate()}, 10);
};

Controller.prototype.uninstall = function()
{
  this.root.parentNode.replaceChild(this.predecessor, this.root)
};

Controller.prototype.expandMacros = function(node)
{
  var item, match, el;
  var elements = node.childNodes;
  for (var i=0; i<elements.length; i++)
  {
    el = elements.item(i);
    match = this.pattern.exec(el.className);
    if (match) this.expand(match[1], el);
    if (el.hasChildNodes()) this.expandMacros(el)
  }
};

Controller.prototype.expand = function(macro, node)
{

   if (! this['_'+macro]) return;
  
/*  try 
  {
*/    expanded = this['_'+macro](node);
/*  } 
  catch (e)
  {
    St.log(e.stack);
    return
  }
*/  
  if (expanded instanceof Array)
  {
    for (var i=0; i<expanded.length; i++)
      node.parentNode.insertBefore(expanded[i], node);
    node.parentNode.removeChild(node)
  }
  else if (expanded && node.parentNode && expanded !== node )
    node.parentNode.replaceChild(expanded, node);
};

Controller.prototype.activate = function()
{
  // do nothing, but may be overridden
};

Controller.prototype.createAction = function(node, selector)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)');
  node.onclick = function() {self[selector]()}; 
}


function Page() {}

Page.prototype = new Controller;

Page.initialize = function()
{
  Template.initialize();
  this.current = new this();
  this.current.installOn(document.documentElement);
}

Page.prototype._runner = function(node)
{
	var controller = new Runner();
	if (/[a-z]+/.test(node.firstChild.data)) controller.original = node.firstChild.data;
  controller.installOn(node, Template.named('Runner'));
};

Page.prototype._embedded = function(node)
{
	var controller = new WikiRunner();
	if (node.firstChild) controller.original = node.firstChild.data;
 	controller.wikiName = node.getAttribute('name');
  controller.installOn(node, Template.named('Runner'));
};

function Runner() {}

Runner.prototype = new Controller;

Runner.prototype._code = function(node)
{
	var self = this;
  this.source = node;

  if (this.original == undefined)
    if(this.source.firstChild != undefined) 
      this.original = this.source.firstChild.data;
    else this.original = '';
  
  this.source.value = this.original;
  
  this.source.adjustRows = function() 
  {
 		this.rows = this.value.split("\n").length;
	}
	
	this.source.run = function()
	{
	  self.evaluator.eval(self.source.value)
	}

	this.source.onchange = this.source.adjustRows;
	this.source.onkeyup = this.source.adjustRows;
  this.source.adjustRows();
  return node;
};

Runner.prototype._codeBox = function(node)
{
  this.codeBox = node;
};

Runner.prototype._draw = function(node)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)');
  node.onclick = function() {self.openDrawing()};
  return node;
}

Runner.prototype._reset = function(node)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)')
  node.onclick = function()
  {
    self.source.value = self.original;
    self.source.adjustRows();
    self.turtle.clearscreen();
    self.transcript.clear();
		return false;
  }
  return node;
};

Runner.prototype._run = function(node)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)');
  node.onclick = function()
  {
    self.evaluator.eval(self.source.value);
		return false;
  }
  return node;
};

Runner.prototype._screen = function(node)
{
  this.turtle = new Turtle(new Screen(node));
  return node;
};

Runner.prototype._sprite = function(node)
{
	this.sprite = new Sprite(node);
};

Runner.prototype._toggle = function(node)
{
  var self = this;
  switch(node.type)
  {
    case 'checkbox':
      node.onchange = function()
      {
        self.exportFunctions(this.checked)
        return false;
      };
      break;
      
    case 'image':
      var oldHandler = node.onclick;
      var bool = true;
      node.onclick = function()
      {
        bool = !bool;
        self.evaluator.exportFunctions(bool);
        oldHandler.apply(node);
        return false;
      }
      break;
  }
  
};

Runner.prototype._transcript = function(node)
{
  var contents = node.firstChild;
  var lines = parseInt(contents.data);
  node.removeChild(contents);

  this.transcript = new Transcript(node);
  this.transcript.limit = lines;
  return node;
};

Runner.prototype.activate = function()
{
	if (this.sprite == undefined) this.sprite = new Sprite;
  this.evaluator = new Evaluator(this.turtle, this.transcript);
	this.turtle.setSprite(this.sprite);
};

Runner.prototype.openDrawing = function()
{
  var editor = new DrawingEditor(this.turtle);
  editor.installOn(this.codeBox, Template.named('DrawingEditor'));
};


function DrawingEditor(turtle) 
{
  this.turtle = turtle
}

DrawingEditor.prototype = new Controller;

DrawingEditor.prototype._clear = function(node)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)');
  node.onclick = function() {self.slate.reset()}
};

DrawingEditor.prototype._inspect = function(node)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)');
  node.onclick = function() {St.inspect(self)};
  return node;
};

DrawingEditor.prototype._install = function(node)
{
  this.createAction(node, 'install')
};

DrawingEditor.prototype._slate = function(node)
{
  this.slate = new Slate(node);
};

DrawingEditor.prototype._write = function(node)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)');
  node.onclick = function() {self.uninstall()};
  return node;
};

DrawingEditor.prototype.install = function()
{
  this.turtle.sprite.clear();
  var renderer = new DrawingRenderer(this.turtle.sprite);
  this.turtle.sprite.renderer = renderer;
  renderer.setDrawing(this.slate.drawing);
};


function WikiRunner() {}

WikiRunner.prototype = new Runner;

WikiRunner.prototype._save = function(node)
{
  var self = this;
  node.setAttribute('href', 'javascript:void(0)');
  node.onclick = function()
  {
    self.save();
  }
  return node;
};

WikiRunner.prototype.getPage = function(name)
{
  var page;
	var pages = el("wiki").childNodes;
	for(i=0; i<pages.length; i++)
		if(pages[i].id)
			if(pages[i].id.toUpperCase() == this.wikiName.toUpperCase())
				page = pages[i];
  if (page == undefined) {
    page = document.createElement('div');
    page.id = name;
    el('wiki').appendChild(page);
  }
  return page;
};

WikiRunner.prototype.save = function()
{
  this.original = this.source.value;
  this.getPage(this.wikiName).innerHTML = escape(this.original);
  saveThisFile();
};

