﻿//import Namespace;
import Primitives;
import Reader;
import Scheduler;
import Transcript;

//
//Bugs:
//
//	Flash player imposes a limit of 256 on the length of the prototype chain which means
//  that the deep recursion used in place of loops in logo will fail (eventually).
//	- We therefore need to manage the prototype chain better or at least detect exhaustion
//	  before the player stops and freezes.
//

class Evaluator {
	var primitives:Primitives;
	var functions:Object /* Namespace */;
	var definitions:Object /* Namespace */;
	var variables:Object /* Namespace */;
	var transcript:Transcript;
	var scheduler:Scheduler;
	var parseTrace:Number = 0;
	var name = "Evaluator";
	
	function Evaluator(transcript) {
		this.transcript = transcript;
		primitives = new Primitives(this);
		
		functions = _root.Namespace(primitives);
		definitions = functions.parent;
		variables = _root.Namespace();
		
		//addPrimitives(functions);
	
		scheduler = new Scheduler();
		scheduler.addPrimitives(functions);
		
		//if (transcript != null) {
		//	transcript.addPrimitives(functions);	
		//}
		
		this["functions"].addAliases();
		//
		// This is broken in actionscript, must find alternative
		//
		//assignArity(functions);
	}
	
	// Core evaluation functions, CPS style
	
	// execute list or pass continuation function back to scheduler
	function run(list, k):Void {
		var self = this;
		if(list.length > 0)
			runOnce(list, function(v){self.run(list, function(){k(v);})});
		else
			cont(k);
	}
	
	// consume and execute first item of list
	function runOnce(list, k):Void {
		//trace("TRACE: " + list);
		var listItem = list.shift();
		/* try this again sometime...
		if(listItem.inParenthesis) {
			var self = this;
			trace("parenthesis");
			run(listItem, k); //function(v){self.run(listItem, function(){k(v);})});
			k(listItem);
		}
		*/
		if (typeof listItem == "string")
		{
			var c:String = listItem.charAt(0);
			if (c == '"')
				k(listItem.slice(1));
			else if (c == ":") 
				k(variables[listItem.slice(1)])
			else if (listItem == 'to')
				defineFunction(list, k);
			else if (listItem == '(')
				callParenthesis(list, k);
			else if (listItem == ')')
				k(listItem);
			else 
				callFunction(listItem, list, k);				
		} else k(listItem);
	}
/*
	Original code

	function defineFunction(list, k):Void
	{
		var name = list.shift();
		var listItem = list.shift();
		var args = [];
		while (listItem.slice(0,1) == ':')
		{
			args.push(listItem.slice(1));
			listItem = list.shift();
		}
		var content = [];
		while (listItem != 'end')
		{
			content.push(listItem);
			listItem = list.shift();
		}
		
		//var self = this;
		var fn = function(kk) {
			//trace("defineFunction fn=Function() {this="+this+"} arguments[0]="+arguments[0]);
			run(
				kk,
				[].concat(content)
			);			
		}
		fn.logoArity = args.length;
		fn.name = name;
		fn.logoArguments = args;
		definitions[name] = fn;
		cont(k);
	}
*/	
	function defineFunction(list, k):Void
	{
		var name = list.shift();
		var listItem = list.shift();
		var args:Array = [];
		var argSchema:Array = [];
		while (listItem.slice(0,1) == ':')
		{
			args.push(listItem.slice(1));
			
			//
			// Unfortunately Logo syntax does not give us parameter types
			// so we can't validate arguments to user defined functions
			//
			// Note: A minor extension to the ':' syntax would circumvent this
			//
			// We are also unable to implement user defined functions with
			// variable length arguments since we need to be able to predict argument
			// length in order to parse the language correctly.
			//
			argSchema.push(LogoFunction.OBJECT);
			
			listItem = list.shift();
		}
		var content = [];
		while (listItem != 'end')
		{
			content.push(listItem);
			listItem = list.shift();
		}
		
		//var self = this;
		
		var fn:LogoFunction = new LogoFunction(
			name, 
			argSchema, 
			false,  // fixed
			function(kk) {
				//trace("defineFunction "+name + " this="+this.name+" content= "+content);
				//var run:LogoFunction = Namespace(this).getFunction("run");
				run.fn.call(this, kk, [].concat(content));			
				
			},
			args);
		definitions[name] = fn;
		cont(k);
	}
	

	function callParenthesis(list, k) {

		var name = list.shift();
		var fun = findFunction(name);
		if (fun == null) {
			return;
		}
		
		var self = this;
		var args = [];
		
		var process_arg = function(v, kk) {
			if (v == ")") {
				self.executeFunction(fun, args, k);
			} else {
				args.push(v);
				self.cont(kk);
			}
		}
		
		var fetchArgs = function() {
			self.runOnce(list, function(v) {process_arg(v, fetchArgs)})
		}
	
		fetchArgs();
	}
	
	function callFunction(name, list, k) {
		var fun = findFunction(name);
		if (fun == null) return;
	
	
		var self = this;
		var args = [];
		
		var fetchArg = function(n, kk) {
			//trace("starting fetchArg("+n+")");
			
			var kkk = function(v) {
				args.push(v); 
				//trace("args = " + args);
				fetchArg(n-1, kk);
			}
			
			if (n == 0) {
				kk();
			}
			else {
				self.runOnce(list, kkk);
			}
			//trace("finished fetchArg("+n+")");
		}
		
		fetchArg(
			fun.logoArity, 
			function() {self.executeFunction(fun, args, k)}
		);
		
	}
	
	function executeFunction(fn, args, k) {
		var self = this;
		
		// save callers stack frame
		var keep = variables;

		// check arguments are OK
		var argError:String = fn.argumentError(args);
		if(argError != null) {
			write("In: " + fn.traceMessage(args));
			abort(argError);
		}
		
		if(fn.traced) {
			write("Calling " + fn.traceMessage(args));
		}
		
		// create own stack frame (inheriting callers')
		variables = _root.Namespace(variables);
		
		// assign passed variables to local logo :vars
		if (fn.logoArguments != null) {
			for (var i=0; i < fn.logoArguments.length; i++) {
				variables[fn.logoArguments[i]] = args[i];
			}
		}
		
		// on completion restore callers stack and then call our continuation routine
		var kk = function (v) {
			if(fn.traced) {
				self.write(fn.name + " returns " + ((v==null) ? "" : v));
			}
			self.variables = keep; 
			k(v);
		}
		
		// get the scheduler to do the real work (so it can insert delays between function calls)
		scheduler.apply(functions, fn, args, kk);
		//trace("finished executeFunction");
	}
	
	// Utility functions, not in continuation parameter style
	
	function cont(k) {
	  scheduler.cont(k);
	}
	
	//function addPrimitives(obj) {
	//	var self = this;
	//
	//}
		
	function eval(str) {
		var self = this;
		var list = (new Reader(functions)).read(str);
		if(parseTrace==1) {
			write("> " + list);
		}
		else {
			//write("> " + str);
		}
		if(!scheduler.running) {
			scheduler.go();
			scheduler.run(this, run, list); //function() {self.run(list, function(v){})});
		}
		else {
			write("Still running");
		}
	}
	
	function findFunction(name) {
		var fun = this.functions[name.toLowerCase()];
		
		if (fun === undefined)
		{
			abort("function '" + name + "' is undefined");
		}
		return fun;
	}
	
	function write(msg:String):Void {
		if (transcript != null) {
			transcript.print(msg);
		}
		else {
			trace(msg);
		}
	}
	
	function abort(msg:String):Void {
		scheduler.doStop();
		write(msg);
	}
	
	function setEscape(k) {
		functions['return'] = function(kk, v){k(v)};
		functions['return'].logoArity = 1;
	}
	
	/*
	function inherit(obj) {
		var constructor = function (){};
		constructor.prototype = obj;
		return new constructor();
	}
	
	function exportFunctions(bool) {
	  if (bool) {
		  definitions = functions.parent;
	  }
	  else {
		  definitions = functions;
	  }
	}
	
	function areFunctionsExported() {
	  return definitions === functions.parent;
	}
	*/
}