﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextArea;
import mx.containers.ScrollPane;
import mx.controls.Button;

// Event metadata tag 
[Event("change")]
[Event("click")]
class Popup extends UIComponent {

	/* Components must declare these member variables to be proper
	   components in the components framework. */
	static var symbolName:String = "Popup";
	static var symbolOwner:Object = Popup;
	var className:String = "Popup";
	
	// The component's graphical representation.
	private var titleLabel:MovieClip;
	private var textBox:MovieClip;
	private var close_btn:MovieClip;
	private var boundingBox_mc:MovieClip;
	private var startDepth:Number = 10;
	
	private var name_label:MovieClip;
	private var password_label:MovieClip;
	private var password_ti:MovieClip;

	private var __title:String;
	private var __code:String;

	function Popup() {
	}
	
	function init():Void {
		super.init();
		boundingBox_mc._visible = false;
		boundingBox_mc._width = 0;
		boundingBox_mc._height = 0;
	}
	
		/* Create child objects needed at start up:
	   The createChildren method is required for components
	   extending UIComponent. */
	public function createChildren():Void {
		titleLabel = createObject("Label", "titleLabel", this.startDepth++);
		titleLabel.text = "Hello There";__title;
		titleLabel._width = 100;
		titleLabel._x = 0;
		titleLabel._y = 0;
		
		textBox = createObject("TextArea", "textBox", this.startDepth++,{_width:200,_height:22,_x:20,_y:30});
		textBox.html = false;
		textBox.text = "Some code here";
		textBox.tabIndex = 1;
		/* Set this text input field to have focus. 
		   Note: Make sure to set select Control > Disable Keyboard Shortcuts
		   in the Flash Debugger if it is not already selected, otherwise 
		   the focus may not set when testing. */
		textBox.setFocus(); 
				
		close_btn = createObject("Button", "close_btn", this.startDepth++,{_width:100,_height:22,_x:240,_y:80});
		close_btn.label = "close";
		close_btn.icon = "CloseIcon";
		close_btn.tabIndex = 3;
		close_btn.addEventListener("click", this);
		
		size();
	}

	/* The draw method is required for v2 components.
	   It is invoked after the component has been
	   invalidated by someone calling invalidate().
	   This batch’s up the changes into one redraw, rather
	   than doing them all individually. This approach leads
	   to more efficiency and better centralization of code. */
	function draw():Void {
		super.draw();
	}

	/* The size method is invoked when the component's size
	   changes. This is an opportunity to resize the children,
	   The size method is required for components extending UIComponent. */
	function size():Void {
		super.size();
		// Cause a redraw in case it is needed.
		invalidate();
	}

	/* Event Handler: 
	   Called by the LogIn button when it receives a mouse click.
	   Since we want this event to be accessible outside of the scope of
	   this component, The click event is dispatched using dispatchEvent. */
	public function click(evt){
		// Update the member variables with the input field contents.
		__code = textBox.text;
		// Dispatch a click event when the button fires one.
		dispatchEvent({type:"click"});
	}

	/* This is the getter/setter for the name property.
	   The [Inspectable] metadata makes the property appear
	   in the Property inspector and allows a default value
	   to be set. By using a getter/setter you can call invalidate
	   and force the component to redraw when the value is changed. */
	[Bindable]
	[ChangeEvent("change")]
	[Inspectable(defaultValue="")]
	function set title(val:String){
		__title = val;
		invalidate();
	}
	
	function get title():String{ 
		return(__title);
	}

}
