﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextInput;
import mx.controls.Button;

// Event metadata tag 
[Event("change")]
[Event("click")]
class LogIn extends UIComponent
{
	/* Components must declare these member variables to be proper
	   components in the components framework. */
	static var symbolName:String = "LogIn";
	static var symbolOwner:Object = LogIn;
	var className:String = "LogIn";

	// The component's graphical representation.
	private var name_label:MovieClip;
	private var password_label:MovieClip;
	private var name_ti:MovieClip;
	private var password_ti:MovieClip;
	private var login_btn:MovieClip;
	private var boundingBox_mc:MovieClip;
	private var startDepth:Number = 10;

	/* Private member variables available publicly through getter/setters.
	   These represent the name and password InputText string values. */
	private var __name:String;
	private var __password:String;

	/* Constructor: 
	   While required for all classes, v2 components require
	   the contstructor to be empty with zero arguments. 
	   All initialization takes place in a required init 
	   method after the class instance has been constructed. */
	function LogIn() {
	}

	/* Initialization code:
	   The init method is required for v2 components. It must also
	   in turn call its parent class init() method with super.init().
	   The init method is required for components extending UIComponent. */
	function init():Void {
		super.init();
		boundingBox_mc._visible = false;
		boundingBox_mc._width = 0;
		boundingBox_mc._height = 0;
	}

	/* Create child objects needed at start up:
	   The createChildren method is required for components
	   extending UIComponent. */
	public function createChildren():Void {
		name_label = createObject("Label", "name_label", this.startDepth++);
		name_label.text = "Name:";
		name_label._width = 200;
		name_label._x = 20;
		name_label._y = 10;
		
		name_ti = createObject("TextInput", "name_ti", this.startDepth++,{_width:200,_heigh:22,_x:20,_y:30});
		name_ti.html = false;
		name_ti.text = __name;
		name_ti.tabIndex = 1;
		/* Set this text input field to have focus. 
		   Note: Make sure to set select Control > Disable Keyboard Shortcuts
		   in the Flash Debugger if it is not already selected, otherwise 
		   the focus may not set when testing. */
		name_ti.setFocus(); 
		
		name_label = createObject("Label", "password_label", this.startDepth++,{_width:200,_heigh:22,_x:20,_y:60});
		name_label.text = "Password:";
		
		password_ti = createObject("TextInput", "password_ti", this.startDepth++,{_width:200,_heigh:22,_x:20,_y:80});
		password_ti.html = false;
		password_ti.text = __password;
		password_ti.password = true;
		password_ti.tabIndex = 2;

		login_btn = createObject("Button", "login_btn", this.startDepth++,{_width:80,_heigh:22,_x:240,_y:80});
		login_btn.label = "LogIn";
		login_btn.tabIndex = 3;
		login_btn.addEventListener("click", this);
		
		size();
		
	}

	/* The draw method is required for v2 components.
	   It is invoked after the component has been
	   invalidated by someone calling invalidate().
	   This batch’s up the changes into one redraw, rather
	   than doing them all individually. This approach leads
	   to more efficiency and better centralization of code. */
	function draw():Void {
		super.draw();
	}

	/* The size method is invoked when the component's size
	   changes. This is an opportunity to resize the children,
	   The size method is required for components extending UIComponent. */
	function size():Void {
		super.size();
		// Cause a redraw in case it is needed.
		invalidate();
	}

	/* Event Handler: 
	   Called by the LogIn button when it receives a mouse click.
	   Since we want this event to be accessible outside of the scope of
	   this component, The click event is dispatched using dispatchEvent. */
	public function click(evt){
		// Update the member variables with the input field contents.
		__name = name_ti.text;
		__password = password_ti.text;
		// Dispatch a click event when the button fires one.
		dispatchEvent({type:"click"});
	}

	/* This is the getter/setter for the name property.
	   The [Inspectable] metadata makes the property appear
	   in the Property inspector and allows a default value
	   to be set. By using a getter/setter you can call invalidate
	   and force the component to redraw when the value is changed. */
	[Bindable]
	[ChangeEvent("change")]
	[Inspectable(defaultValue="")]
	function set name(val:String){
		__name = val;
		invalidate();
	}
	
	function get name():String{ 
		return(__name);
	}
	
	[Bindable]
	[ChangeEvent("change")]
	[Inspectable(defaultValue="")]
	function set password(val:String){
		__password=val;
		invalidate();
	}
	
	function get password():String{ 
		return(__password);
	}
	
}