﻿class Towers extends MovieClip {
	var diskCount:Number=4;
	var startN:Number=0;
	var endN:Number=1;
	var moveN:Number = 0;
	
	var maxDisks:Number = 10;
	var disks:Array;
	var base:MovieClip;
	var startPeg:MovieClip;
	var endPeg:MovieClip;
	var midPeg:MovieClip;
	var midMap:Array = [[-1,2,1],[2,-1,0],[1,0,-1]];
	var stacks:Array;
	var pegs:Array;
	var volumes:Array;
	var drums:Array;
	var finished:Boolean;
	
	function Towers() {
		reset(diskCount);
	}

	function pegEnd():Boolean {
		return diskCount % 2 != 0/* || diskCount == 2 || diskCount == 6*/;
	}
	
	var intervalId:Number = null;
	function play():Void {
		if(finished) {
			reset(diskCount);
		}
		intervalId = setInterval(this, "moveDisk", 400);
	}
	function pause():Void {
		clearInterval(intervalId);
	}
	function reset(dcount:Number):Void {
		finished = false;
		while(disks.length > 0) {
			var d:MovieClip = MovieClip(disks.pop());
			d.removeMovieClip();
		}
		moveN = 0;
		diskCount = dcount;
		if(pegEnd()) {
			endN = 2;
		}
		else {
			endN = 1;
		}
		trace("endN = " + endN);
		disks=[];
		stacks=[[],[],[]];
		drums=[[],[],[]];
		volumes=[100, 100, 100];
		base = this["base"];
		startPeg=this["peg"+startN];
		endPeg=this["peg"+endN];
		midPeg=this["peg"+midMap[startN][endN]];
		pegs=[startPeg, midPeg, endPeg];
		trace("pegs = " + pegs);
		(startPeg.sound = new Sound()).attachSound("drum2");
		if(endN==2) {
			(midPeg.sound = new Sound()).attachSound("drum0");
			(endPeg.sound = new Sound()).attachSound("drum1");
		}
		else {
			(midPeg.sound = new Sound()).attachSound("drum1");
			(endPeg.sound = new Sound()).attachSound("drum0");
		}
		for(var i:Number=0; i < diskCount; i++) {
			disks[i] = attachMovie("Disk"+ (maxDisks - diskCount +i), "disk" + i, i, {_x:startPeg._x+startPeg._width/2, _y:base._y-((i+1)*20)});
			disks[i]._x -= disks[i]._width/2;
			disks[i].sound = [];
			stacks[0][i]=disks[i];
		}
	}
	
	function moveDisk():Void {
		var m:Object = nthMove(++moveN);
		//trace("moveDisk from "+m.source + " to " + m.target);
		var source:Array = stacks[m.source];
		var target:Array = stacks[m.target];
		if(source.length >= 1) {
			var disk:MovieClip = MovieClip(source.pop());
			target.push(disk);
			var tgtPeg:MovieClip = MovieClip(pegs[m.target]);
			disk._x = tgtPeg._x+tgtPeg._width/2-disk._width/2;
			disk._y = base._y-((target.length)*20);
			var s:Sound = Sound(pegs[m.target].sound);
			
			if(endN != 2) {
				switch(m.target) {
					case 0:
						s.setPan(-100);
						break;
					case 1:
						s.setPan(100);
						break;
					case 2:
						s.setPan(0);
						break;
				}
			}
			else {
				s.setPan((m.target-1)*100);
			}
			//s.setVolume(volumes[m.target]*(0.2+0.7*Math.random())); 
			s.setVolume((disk._width-40)*80/135+20); 
			s.start();
			if(target.length == diskCount) {
				finished = true;
				clearInterval(intervalId);
			}
		}
	}
	
	function nthMove(n:Number):Object {		
		return {source:((n&(n-1))%3), target:(((n|(n-1))+1)%3)}; 
	}
	
	function traceSolution(N:Number):Void {
		for(var n=1; n < N; n++) {
			var move:Object = nthMove(n);
			trace("from peg: " + move.source + " to: "+move.target);
		}
	}
	
}

