﻿import mx.managers.DepthManager;
import mx.core.UIComponent;
import Expression;
import Complex;
import Subject;
import Constraint;
//
// This is the View of the {Subject, SubjectView, SubjectPanel} MVC triplet.
// operating in conjunction with {ComplexState, ComplexView, Console} 
//
class SubjectView extends MovieClip {
	var subject:Subject;
	var pressPoint:Complex;
	var snapRadius:Number = 3;
	var color:Color;
	var subLabel:MovieClip;
	var drawPane:MovieClip;
	var screenPos:Complex;
	//var velocity:Complex;
	
	private var _penDown:Boolean = false;
	private var _useMouseMode:Boolean = false;
	private var _useKeysMode:Boolean = false;
	private var _mouseIsDown:Boolean = false;
	private var _moved:Boolean = false;
	private var __labelVisible:Boolean = true;
	private var _lastBarfTime:Number;

	static var degrees:Number = 30;
	static var step:Number = 1.1;
	
	var delta:Number = 0;
	
	//private var _turn:Number = 0;
	private var _deltaTurn:Number = 0;
	private var _velocity:Complex;
	//public var complexStep:Complex;
	
	function SubjectView() {
		init();
	}
	
	function init():Void {
		color = new Color(this);
		screenPos = new Complex(_x,_y);
		//_turn = 0;
		velocity = new Complex(10);

		delta = step;
		//complexStep = new Complex(velocity);

		//trace("subject " + subject.id + " is free? " + subject.definition.isFreePoint());
		if(subject.isFree()) {
			rgb=0xff0000;
		}
		else {
			rgb=0x888888;
		}
		//trace("SubjectView 45: drawPane="+drawPane);
		createSubjectPanel();
		createLabel();
		//subject.panel.picker.color = rgb;
		//subject.panel.colourChange();
		drawPane.moveTo(_x,_y);
		onRelease = doRelease;
		onPress = doPress;
		
		if(subject.isFree())
			Key.addListener(this);
		
		//drawIcon("flag");
		
		trace("SubjectView parent is "+_parent);
		
	}
	
	// move() is the function that actually realises the subject move on screen, along with
	// any associated drawing. The icon for z is realised in this SubjecView, but its path is
	// realised on the drawPlane.
	
	function move(z:Complex) {
		//trace("moveTo " + z);
		z = _parent.complexToScreen(z);
		_x = z.x;
		_y = z.y;
		
		/*
		
		if(redrawIcon)
			drawIcon("flag");
		else
			clear();
		*/
		
		/*
		if(bleeper_mc.hitTest(_x,_y, true) {
		}
		*/
		if(subject.penDownLike != null) {
			_penDown = subject.penDownLike.view.penDown;
		}
		
		if(_penDown) {
			//trace("lineTo: "+z);
			drawPane.lineTo(_x,_y);
		}
		else {
			//trace("moveTo: "+z);
			drawPane.moveTo(_x,_y);
		}
		if(subject.panel._visible) {
			subject.panel.place();
		}
		//placeLabel(); 
	}
	
	function clearIcon():Void {
		clear();
		lineStyle(1,0x0,100);
	}
	
	function plotIcon(z:Complex):Void {
		z = _parent.complexToScreen(z);
		lineTo(z.x-_x, z.y-_y);
	}
	
	function drawIcon(name:String):Void {
		trace("drawIcon");
		clear();
		lineStyle(1,0x0,100);
		moveTo(0, 0);
		lineTo(0,-40);
		lineTo(20,-40);
		lineTo(20,-20);
		lineTo(0,-20);
	}
	
	function set useKeys(b:Boolean):Void {
		_useKeysMode = b;
		useMouseMode = !b;
	}
	
	function get useKeys():Boolean {
		return _useKeysMode;
	}
	
	function onKeyDown():Void {
		var kc:Number = Key.getCode();
		var k:String = String.fromCharCode(kc).toUpperCase();
		if(k == "K") {
			useKeys = !useKeys;
		}
		switch (Key.getCode()) {
				
				case Key.LEFT :
				_deltaTurn = -degrees;
				velocity = velocity.times(new Complex(1,Math.PI*_deltaTurn/180,true));
				//_x -= step;
				break;
	
				case Key.UP :
				velocity=velocity.times(step);
				//_y -= step;
				break;
			
				case Key.RIGHT :
				_deltaTurn = degrees;
				velocity = velocity.times(new Complex(1,Math.PI*_deltaTurn/180,true));
				//_x += step;
				//onMove();
				break;
	
				case Key.DOWN :
				velocity = velocity.over(step);
				//_y += step;
				//onMove();
				break;
		}
		if(_useKeysMode) {
			switch (Key.getCode()) {
				
				case Key.CONTROL :
				_penDown = !_penDown;
				break;
				
				/*
				case Key.LEFT :
				_deltaTurn = -degrees;
				velocity = velocity.times(new Complex(1,Math.PI*_deltaTurn/180,true));
				//_x -= step;
				break;
	
				case Key.UP :
				velocity=velocity.times(step);
				//_y -= step;
				break;
			
				case Key.RIGHT :
				_deltaTurn = degrees;
				velocity = velocity.times(new Complex(1,Math.PI*_deltaTurn/180,true));
				//_x += step;
				//onMove();
				break;
	
				case Key.DOWN :
				velocity = velocity.over(step);
				//_y += step;
				//onMove();
				break;
				*/
				case Key.SPACE:
				//case Key.ESCAPE:
				//trace("ENTER: "+velocity);
				//turn += _deltaTurn; 
				velocity = velocity;//.times(new Complex(1,Math.PI*_deltaTurn/180,true)); //velocity.times((new Complex(0,Math.PI*_deltaTurn/180)).exp());
				screenPos = screenPos.plus(velocity);
				//velocity = new Complex()
				//velocity = velocity.times(delta/velocity.length);
				_deltaTurn = 0;
				_x = screenPos.x;
				_y = screenPos.y;
				break;
			}
		}
	}
	
	function onKeyUp():Void {
		if(_useKeysMode) {
			switch (Key.getCode()) {
				//case Key.SPACE :
				//_penDown = false;
				//break;
				
				case Key.LEFT:
				case Key.RIGHT:
				case Key.UP:
				case Key.DOWN:
				case Key.SPACE:
				//case Key.ESCAPE:
				onMove();
				break;
				
			}
		}
	}
	
	function set penDown(b:Boolean):Void {
		_penDown = b;
	}
	
	function get penDown():Boolean {
		return _penDown;
	}

	function set useMouse(b:Boolean):Void {
		//trace("SV 60: useMouse = "+b);
		_useMouseMode = b;
	}
	
	function get useMouse():Boolean {
		return _useMouseMode;
	}
	
	// drawMode is called on SubjectPanel draw mode combo change
	function drawMode(mode:Number):Void {
		trace("drawMode = " + mode);
		switch(mode) {
			case SubjectPanel.USEMOUSE: {
				useKeys = false;
				useMouseMode = true;
				_penDown = false;
				break;
			}
			case SubjectPanel.PENUP: {
				useKeys = false;
				useMouseMode = false;
				_penDown = false;
				break;
			}
			case SubjectPanel.PENDOWN: {
				useKeys = false;
				useMouseMode = false;
				_penDown = true;
				break;
			}
			case SubjectPanel.USEKEYS: {
				useKeys = true;
				break;
			}
			default: trace("Unknown drawMode: " + mode);
		}
	}
	
	function setScreenPos(x:Number, y:Number):Void {
		screenPos.x = x;
		screenPos.y = y;
	}
	
	function set useMouseMode(b:Boolean):Void {
		_useMouseMode = b;
		if(b) {
			//onRelease = null;
			onMouseDown = function() {
				if(!subject.panel._visible) {
					_x = _root._xmouse;
					_y = _root._ymouse;
					setScreenPos(_x, _y);
					_penDown = false;
					_mouseIsDown = true;
					onMove();
				}
				_moved = false;
			}
			onMouseMove = function() {
				if(!subject.panel._visible) {
					_x = _root._xmouse;
					_y = _root._ymouse;
					setScreenPos(_x, _y);
					_penDown = _mouseIsDown;
					onMove();
				}
			}
			onMouseUp = function() {
				//trace("onMouseUp");
				_penDown = false;
				_mouseIsDown = false;
				if(moveCheck()) {
					//setScreenPos(_root._xmouse, _root._ymouse);
					onMove();
				}
				//_moved = false;
			}
		}
		else {
			onMouseDown = null;
			onMouseUp = null;
			onMouseMove = null;
			//onRelease = doRelease;
			//onPress = doPress;
		}
	}
	
	function set visible(b:Boolean):Void {
		_visible = b;
		drawPane._visible = b;
	}
	
	function clearPane():Void {
		drawPane.clear();
		rgb = rgb;
		drawPane.moveTo(_x,_y);
	}

	function removeMovieClip():Void {
		subLabel.removeMovieClip();
		drawPane.removeMovieClip();
		super.removeMovieClip();
	}
	
	function set rgb(colour:Number):Void {
		//trace("SubjectView 112:  "+subject.id + ".rgb = " + colour.toString(16));
		color.setRGB(colour);
		//subject.panel.setColour();
		drawPane.lineStyle(3,colour,50);
	}

	function get rgb():Number {
		return color.getRGB();
	}
	
	function onMove():Void {
		var pos:Complex = new Complex(_x,_y);
		//trace("pressPoint = "+pressPoint);
		_moved = _moved || (pressPoint.minus(pos).length >= snapRadius);			

		if(subject.constraint != null) {
			if(!subject.constraint.inside(pos)) {
				var now:Number = getTimer();
				if(_lastBarfTime == null || now - _lastBarfTime > 1000) {
					_lastBarfTime = now;
					Subject.barf.start();
				}
			}
			pos = subject.constraint.insidePoint = subject.constraint.nearestInside(pos);
		}
		
		
		var z:Complex = _parent.screenToComplex(pos);
		//trace("Redefining: " + subject.id +'='+z);
		try {
			subject.definition = new Expression(z);
			//subject.panel.update();
		}
		catch(err:Error) {
			trace("SubjectView 69:"+err);
		}
	}

	
	function onRollOver() {
		subLabel._visible = __labelVisible;
	}
	
	function onRollOut() {
		//subLabel._visible = false;
	}
	
	function doPress() {
		// start drag if free
		pressPoint = new Complex(_x,_y);
		_moved = false;
		if(_useMouseMode) {
			return;
		}
		if(subject.isFree()) {
			this.startDrag();
			onMouseMove = function() {
				//setScreenPos(_root._xmouse, _root._ymouse);
				onMove();
			}
		}
	}
	
	function moveCheck():Boolean {
		if (_moved)  {
			return true;
		}
		//
		// Interpret very short drags as clicks
		//
		_x = pressPoint.x;
		_y = pressPoint.y;
		onClick();
		return false;
	}
	
	function doRelease() {
		if(_useMouseMode) {
			onMouseUp();
			return;
		}
		onMouseMove = null;
		if(subject.isFree()) {
			this.stopDrag();
			if(moveCheck()) {
				//setScreenPos(_root._xmouse, _root._ymouse);
				onMove();
			}
		}
		else {
			onClick();
		}
	}
	
	function onReleaseOutside() {
		onRelease();
	}
	
	function onClick() {
		//useMouseMode = false;
		showSubjectPanel();
		//useMouseMode = subject.panel.useMouseMode;
	}
	
	function createSubjectPanel() {
		//trace("SV 213: creating subject panel "+ subject.id);
		subject.panel = SubjectPanel(_parent.createChildAtDepth("SubjectPanel", DepthManager.kTop, {subject:subject, _visible:false}));	
	}
	
	function showSubjectPanel() {
		subject.panel.update();
		subject.panel._visible = true;
		subLabel._visible = false;
	}
	
	function hideSubjectPanel() {
		subject.panel._visible = false;
		subLabel._visible = __labelVisible;
	}
	
	function createLabel():Void {
		subLabel = attachMovie("SubLabel", "subLabel", 1, {_visible:true});
		subLabel.text = subject.id;
		placeLabel();
	}
	
	function placeLabel():Void {
		subLabel._x = 5, 
		subLabel._y = -15;
	}
	
	function set labelVisible(b:Boolean):Void {
		if(b) {
			onClick = showSubjectPanel;
			subLabel._visible = __labelVisible = true;
		}
		else {
			var x = _x;
			var y = _y;
			onClick = undefined; /*function(){
				x = _root._xmouse;
				y = _root._ymouse;
				setScreenPos(x,y);					
				_penDown = true;
				_mouseIsDown = true;
				onMove();
			};*/
			subLabel._visible = __labelVisible = false;
		}
	}
	
	function drawLine():Void {
	}
	
	function set velocity(v:Complex):Void {
		_velocity = v;
		subject.transformedIcon = null;
		var a:Array = subject.transformedIcon;
		_parent.dzInput.text = _parent.screenToDelta(v).toString();
	}
	
	function get velocity():Complex {
		return _velocity;
	}
}