﻿import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextInput;
import mx.controls.Button;
import mx.controls.ComboBox;
import Subject;
import SubjectView;
import Expression;
import ComplexState;
class SubjectPanel extends UIComponent {
	var subject:Subject;
	var base:MovieClip;
	var id:Label;
	var defbox:TextInput;
	var valbox:Label;
	var picker:Object;
	var okButton:Button;
	var clearButton:Button;
	var drawMode:ComboBox;
	var SW:Number = 550;
	var SH:Number = 400;
	var firstColourChange:Boolean = true;
	//var mouseFollower: Subject;
	public static var PENUP:Number = 0;
	public static var PENDOWN:Number = 1;
	public static var USEMOUSE:Number = 2;
	public static var USEKEYS:Number = 3;
	
	function init() {
	}
	
	function draw() {
		//trace("SubjectPanel.draw ");
		base = this["base"];
		id = this["id"];
		defbox = this["defbox"];
		valbox = this["valbox"];
		clearButton = this["clear_btn"];
		okButton = this["okButton"]
		drawMode = this["drawMode"];
		drawMode.selectedIndex = 0;
		drawMode.addEventListener("change", this);
		
		picker = this["picker"];
		picker.color = subject.view.rgb;
		if(subject.isFree()) {
			firstColourChange = true;
			picker.color = 0xFF0000;
		}
		
		// fill in values:
		id.text = subject.id;
		defbox.text = subject.lines[0].statement;
		valbox.text = subject.evaluated.displayString(0);
		
		// button actions
		okButton.onRelease = function() {
			_parent.subject.view.hideSubjectPanel();
			_parent.defboxChanged();
		}
		
		clearButton.onRelease = function() {
			_parent.subject.clear();
		}
		
		// drag actions
		base.onPress = function() {
			_parent.startDrag();
		}
		
		base.onRelease = function() {
			_parent.stopDrag();
		}
		
		base.onReleaseOutside = function() {
			_parent.stopDrag();
		}
		
		// place on screen sensibly
		place();
	}
	
	function defboxChanged() {
		var e:Expression = new Expression(defbox.text);
		subject.definition = e;
		subject.view.move(subject.evaluated);
		update();
	}

	function update():Void {
		//trace("SP:91: update()");
		id.text = subject.id;
		defbox.text = subject.definition.displayString(0);
		place();
		colourFromView();
		drawModeFromView();
	}
	
	function place():Void {
		// place on screen sensibly
		var v:SubjectView = subject.view;
		valbox.text = subject.evaluated.displayString(0);
		if(v._x+base._width + 10 < SW) {
			_x = v._x + 10;
		}
		else {
			_x = v._x - 5 - base._width;
		}
		_y = v._y;
		
		// Make sure we are still on screen
		_x = Math.max(0,_x);
		_y = Math.max(0,_y);
		_x = Math.min(SW-base._width,_x);
		_y = Math.min(SH-base._height,_y);

	}
	
	/*
	function setColour():Void {
		doLater(this, "colourFromView");
	}
	*/
	
	private function colourFromView():Void {
		picker.color = subject.view.rgb;
	}
	
	function colourChange():Void {
		//trace("colourChange: " + this);
		var rgb:Number = picker.color; //subject.isFree() ? 0xff0000 : picker.color;
		//subject.view.rgb = rgb;
		//picker.color = rgb;
		//trace("colourChange: picker.color = " + picker.color.toString(16) + " rgb = " + rgb.toString(16));
		//picker.invalidate();
		//picker.draw();
		if(firstColourChange) {	
			firstColourChange = false;
		}
		else {
			ComplexState(Expression.state).addStatement(new Line(subject.id + " paints " + rgb, 0));
		}
	}
	
	function change(evt):Void {
		switch(evt.target) {
			case drawMode: {
				subject.view.drawMode(drawMode.selectedIndex);
				break;
			}
		}
	}
	
	function drawModeFromView():Void {
		var v:SubjectView = subject.view;
		if(v.useKeys) {
			drawMode.selectedIndex = USEKEYS;
		}
		else {
			if(v.useMouse) {
				useMouseMode = true;
			}
			else {
				penDown = v.penDown;
			}
		}
	}
	
	function get useMouseMode():Boolean {
		return (drawMode.selectedIndex == USEMOUSE);
	}
	
	function set useMouseMode(b:Boolean):Void {
		//trace("SP:169 set useMouseMode");
		drawMode.selectedIndex = b ? USEMOUSE : PENUP;
	}
	
	function set penDown(b:Boolean):Void {
		drawMode.selectedIndex = b ? PENDOWN : PENUP;
	}
	
	function get penDown():Boolean {
		return (drawMode.selectedIndex == PENDOWN);
	}
	
}