﻿//The X axis of the sphere is the x axis of flash. The Z axis is the -y axis. 
//The Y axis points behind the screen.
//i.e. map is (X,Y,Z) --> (rX,-rZ).

class Sphere extends MovieClip {
	
	//The actual radius of sphere.
	var radius:Number = 100;
	
	//Keep track of the points i=(1,0,0),  j=(0,1,0), and k=(0,0,1).
	var I,J,K:Array;
	
	//Save I,J,K. Whilst rotating, need to save previous values.
	var saveI,saveJ,saveK:Array;
	
	//Record where sphere is pressed.
	var r:Array;
	
	//Constructor.
	function Sphere() {
		init();
	}
	
	//Initialisation function.
	function init():Void {
		trace("init");
		
		//Initialise I,J,K, and record.
		I = saveI = [1,0,0];
		J = saveJ = [0,1,0];
		K = saveK = [0,0,1];
		r = [null,null,null];
		
		
		//Centre the thing.
		_x = _y = 200;
		
		//Attach spot to sphere.
		attachMovie("spot","spot", this.getNextHighestDepth(),{_x:0,_y:-radius});
		
		this.onPress = pressed;
		this.onRelease = released;
		this.onReleaseOutside = released;
		this.onMouseMove = mouseMoved;
	}
	
	//Redraw the geometry.
	function draw() {
		this["spot"]._x = radius*K[0];
		this["spot"]._y = -radius*K[2];
		this["spot"]._alpha = (K[1]<0) ? 100 : 30;
	}
	
	//Operates when sphere pressed.
	function pressed():Void {
		
		//If press on sphere, record where pressed.
		var p_x = _level0._xmouse-_x;
		var p_y = _level0._ymouse-_y; 
		if ( p_x*p_x+p_y*p_y < radius*radius ) {trace("in");
			r[0] = p_x/radius;
			r[2] = -p_y/radius;
			r[1] = -Math.sqrt(1-r[0]*r[0]-r[2]*r[2]);
		}
		
	}
	
	//Operates when sphere released.
	function released():Void {
		trace("releaseded");
		
		//Record where have let go of sphere.
		saveI = I;
		saveJ = J;
		saveK = K;
		
		//Nullify the point record.
		r[0]=r[1]=r[2] = null;
	}
	
	//Operates when mouse moves.
	function mouseMoved():Void {
		//Only operate if sphere has been pressed.
		if (r[0] != null) {
			//trace("moved");
		
			//Current point.
			var p = new Array(3);
		
			//Locate the point on the sphere where mouse is.
			//If mouse off sphere then project inwards radially.
			var p_x = _level0._xmouse-_x;
			var p_y = _level0._ymouse-_y;
			var sq = p_x*p_x+p_y*p_y;
			if ( sq < radius*radius ) {
				p[0] = p_x/radius;
				p[2] = -p_y/radius;
				p[1] = -Math.sqrt(1-p[0]*p[0]-p[2]*p[2]);
			} else {
				p[1]=0;
				var sqrt = Math.sqrt(sq);
				p[0] = p_x/sqrt;
				p[2] =  -p_y/sqrt;
			}
			
			//trace("record = "+record);
			//trace("p = "+p);
		
			var c = orthog(r,p);
			var d = orthog(c,r);
			
			/*
			var temp1 = c[0]*p[0]+c[1]*p[1]+c[2]*p[2];
			var temp2 = c[0]*record[0]+record[1]*c[1]+c[2]*record[2];
			trace("Check orthog1: " + temp1);
			trace("Check orthog2: " + temp2);
			*/
			
			//trace("c = "+c);
			//trace("d = "+d);
			
			//trace("r = "+r);
		
			//Returns angles in [0,pi].
			//var theta = Math.acos(p[0]*r[0]+p[1]*r[1]+p[2]*r[2]);
			//trace("theta = "+theta);	
			var cos = p[0]*r[0]+p[1]*r[1]+p[2]*r[2];
			var sin = Math.sqrt(1-cos*cos);
			
			//Find image of I.
			//Change of basis matrix action on I.
			var i:Array = saveI;
			//trace("i = "+i);
			I = [c[0]*i[0]+c[1]*i[1]+c[2]*i[2],r[0]*i[0]+r[1]*i[1]+r[2]*i[2],
				 d[0]*i[0]+d[1]*i[1]+d[2]*i[2]];
			i = I;
			
			//trace("I1 = "+I);
			//trace("cos ="+Math.cos(theta));
			
			//Rotation action.
			I = [i[0],cos*i[1]-sin*i[2],sin*i[1]+cos*i[2]];
			i=I;
			
			//trace("I2 = "+I);
			
			//Change basis back.
			I = [c[0]*i[0]+r[0]*i[1]+d[0]*i[2],c[1]*i[0]+r[1]*i[1]+d[1]*i[2],
				c[2]*i[0]+r[2]*i[1]+d[2]*i[2]];
		
			//trace("I3 = "+I);
		
			i = saveJ;
			J = [c[0]*i[0]+c[1]*i[1]+c[2]*i[2],r[0]*i[0]+r[1]*i[1]+r[2]*i[2],
				 d[0]*i[0]+d[1]*i[1]+d[2]*i[2]];
			i = J;
			J = [i[0],cos*i[1]-sin*i[2],sin*i[1]+cos*i[2]];
			i=J;
			J = [c[0]*i[0]+r[0]*i[1]+d[0]*i[2],c[1]*i[0]+r[1]*i[1]+d[1]*i[2],
				c[2]*i[0]+r[2]*i[1]+d[2]*i[2]];
			
			//trace("J = "+J);
			
			//Quicker than calling orthog is to compute explicitly as no Math.sqrt.
			//K = orthog(I,J);
			K = [I[1]*J[2]-I[2]*J[1],I[2]*J[0]-I[0]*J[2],I[0]*J[1]-I[1]*J[0]];
			
			//trace("K = "+K);
		
			draw();
		}
	}
	
	//Returns a unit vector c orthogonal to unit vectors a and b.
	function orthog(a,b:Array):Array {
		var c:Array  = [a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]];
		var norm = Math.sqrt(c[0]*c[0]+c[1]*c[1]+c[2]*c[2]);	
		return [c[0]/norm,c[1]/norm,c[2]/norm];
	}
	
}