﻿//
// a place filler for flash.geom.Point
//
class Point {
	var x:Number = 0;
	var y:Number = 0;
	function Point(x:Number, y:Number) {
		this.x = x;
		this.y = y;
	}
	public function plus(p:Point):Point {
		return new Point(x+p.x,y+p.y);
	}
	public function subtract(p:Point):Point {
		return new Point(x-p.x, y-p.y);
	}
	public function clone() {
		return new Point(x,y);
	}
	public function get length():Number {
		return Math.sqrt(x*x+y*y);
	}
	public static function distance(pt1:Point, pt2:Point) {
		var dx = pt1.x - pt2.x;
		var dy = pt1.y - pt2.y;
		return Math.sqrt(dx*dx+dy*dy);
	}
	public function normalize(len:Number):Void {
		var l:Number = length;
		x *= (len/l);
		y *= (len/l);
	}
	public function offset(dx:Number, dy:Number):Void {
		x += dx;
		y += dy;
	}
	public function equals(p:Object) {
		return (x==p.x && y==p.y);
	}
	public static function interpolate(pt1:Point, pt2:Point, f:Number):Point {
		var g = 1-f;
		return new Point(f*pt2.x + g*pt1.x, f*pt2.y + g*pt1.y)
	}
	public static function polar(len:Number, angle:Number):Point {
		return new Point(len*Math.cos(angle), len*Math.sin(angle));
	}
	public function toString():String {
		return "(x="+x+", y="+y+")";
	}
}