﻿//****************************************************************************
// This is a version of the Flash Player 8 only flash.geom.Matrix
// coded in actionscript so it is compatible with earlier players.
// Replace with flash.geom.Matrix once everyone has player 8 installed.
//****************************************************************************
//import flash.geom.Point;
import Point;
import Vector; // added so these matrices can act on my Vector class
class Matrix
{
	var a:Number = 1;
	var b:Number = 0;
	var c:Number = 0;
	var d:Number = 1;
	var tx:Number = 0;
	var ty:Number = 0;

	public function Matrix(a:Number,  b:Number,
						   c:Number,  d:Number,
						   tx:Number, ty:Number) {
		if(a != null) {
			this.a = a;
			if(b != null) {
				this.b = b;
				if(c != null) {
					this.c = c;
					if(d != null) {
						this.d = d;
						if(tx != null) {
							this.tx = tx;
							if(ty != null) {
								this.ty = ty;
							}
						}
					}
				}
			}
		}
	}
	
	public function clone():Matrix {
		return new Matrix(a,b,c,d,tx,ty);
	}
	
	public function concat(m:Matrix):Void {
		var me:Matrix = clone();
		a = me.a*m.a + me.b*m.c;
		b = me.a*m.b + me.b*m.d,
		c = me.c*m.a + me.d*m.c,
		d = me.c*m.b + me.d*m.d,
		tx = me.a*m.tx + me.b*m.ty + me.tx,
		ty = me.c*m.tx + me.d*m.ty + me.ty;
		delete me;
	}
	
	public function invert():Void {
		var me:Matrix = clone();
		var det = a*d-b*c;
		// if det == 0, we'll get duff values in the following
		a = me.d/det;
		b = -me.b/det;
		c = -me.c/det;
		d = me.a/det;
		tx = (me.b*me.ty-me.d*me.tx)/det;
		ty = (me.d*me.tx-me.a*me.ty)/det;
		delete me;
	}
	
	public function identity():Void {
		a = 1;
		b = 0;
		c = 0;
		d = 1;
		tx = 0;
		ty = 0;
	}
	
	public function createBox (scaleX:Number, scaleY:Number, rotation:Number, tx:Number, ty:Number):Void {
		identity();
		rotate(rotation);
 		scale(scaleX, scaleY);
 		translate(tx,ty);
	}
	
	public function createGradientBox (width:Number, height:Number, rotation:Number, tx:Number, ty:Number):Void {
		trace("Not implemented yet");
	}

	public function rotate(angle:Number):Void {
		var cs = Math.cos(angle);
		var sn = Math.sin(angle);
		var m:Matrix = new Matrix(cs, sn, -sn, cs);
		concat(m);
	}
	
	public function translate(tx:Number, ty:Number):Void {
		this.tx += tx;
		this.ty += ty;
	}
	
	public function scale(sx:Number, sy:Number):Void {
		//
		// The flash.geom.matrix version of this appears to scale
		// the translation first rather than just applying the scaling
		// matrix.
		//
		tx *= sx;
		ty *= sy;
		//
		// 
		//
		var m:Matrix = new Matrix(sx, 0, 0, sy);
		concat(m);
	}
	
	public function deltaTransformPoint(pt:Point):Point {
		return new Point(a*pt.x + b*pt.y,
						 c*pt.x + d*pt.y);
	}
	
	public function transformPoint(pt:Point):Point {
		return new Point(a*pt.x + b*pt.y + tx,
						 c*pt.x + d*pt.y + ty);
	}
	public function deltaTransformVector(v:Vector):Vector {
		return new Vector({x:a*v.x + b*v.y,
						   y:c*v.x + d*v.y});
	}
	
	public function transformVector(v:Vector):Vector {
		return new Vector({x:a*v.x + b*v.y + tx,
						   y:c*v.x + d*v.y + ty});
	}


	public function toString():String {
		return "(a="+a+", b="+b+", c="+c+", d="+d+", tx="+tx+", ty="+ty+")";
	}	
}