﻿import mx.core.UIComponent;
import mx.utils.Delegate;
import mx.controls.TextArea;
import mx.controls.Button;
import ComplexView;
import Expression;
import Line;
class Console extends UIComponent {
	var codeArea:TextArea;
	var runButton:Button;
	var refreshButton:Button;
	var view:ComplexView;
	var state:ComplexState;
	
	function draw() {
		_alpha = 20;
		if(state == null) {
			state = new ComplexState(view);
			//Expression.state = state;
		}
		
		codeArea = this["codeArea"];
		runButton = this["runButton"];
		refreshButton = this["refreshButton"];
		
		// set initial control status
		//runButton._x = 10;
		runButton.enabled = true;
		refreshButton._visible = true;
		
		// initialise TextArea handlers
		codeArea.addEventListener("focusIn", this);
		codeArea.addEventListener("change", this);
		
		// initialise Button handlers
		runButton.addEventListener("click", this);
		refreshButton.addEventListener("click", this);
		
		// initialise View handlers
		//state.addEventListener("create", Delegate.create(view, view.create));
		//state.addEventListener("create", this);
		//state.addEventListener("update", Delegate.create(view, view.update));
		//state.addEventListener("update", this);
	}
	
	function focusIn(evt:Object):Void {
		switch(evt.target) {
			case codeArea:
				refresh();
				break;
		}
	}
	/*
	 * TODO: Use these to implement addPointToSet by clicking in z={} and then in ComplexView
	 *
	function focusOut(evt:Object):Void {
		switch(evt.target) {
			case codeArea:
				trace("code length = " + codeArea.length);
				break;
			case statusArea:
				trace("status length = " + codeArea.length);
				break;
		}
	}
	function onMouseUp():Void {
		var count = Selection.getEndIndex()-Selection.getBeginIndex();
		var s:String = codeArea.text.substr(Selection.getBeginIndex(), count);
		trace("selection = " + s + " count = " + count);
	}
	*/
	function change(evt:Object):Void {
		switch(evt.target) {
			case codeArea:
				if(codeArea.text != "") {
					runButton.enabled = true;
				}
				break;
		}
	}
	function click(evt:Object):Void {
		switch(evt.target) {
			case runButton:
				//trace("run");
				if(runButton.label == "Run") {
					run();
				}
				else {
					trace("runButton");
					codeArea._visible = true;
					codeArea.setFocus();
					runButton.label = "Run";
				}
				break;
			case refreshButton:
				//trace("refresh");
				refresh();
				break;
		}
	}
	//
	// run a Plex script entered in the codeArea
	//
	function run():Void {
		var lines:Array = codeArea.text.split("\r");
		trace("lineCount = "+lines.length + " state= "+state);
		state.reset();
		for(var lnum=0; lnum < lines.length; lnum++) {
			//trace("line: " + lnum + " = " + lines[lnum]);
			var s:String = lTrim(lines[lnum]);
			if(s != "") {
				try {
					// trace("Console: 104 "+s);
					var line = new Line(s);
					//var e:Expression = new Expression(s);			
					state.addStatement(line);
				}
				catch(err:Error) {
					trace("Error:" + lnum + " " + err);
					view.statusMessage(err.toString(), 5000);
				}
			}
		}
		try {
			// calculate how variables depend on each other and set up
			// event chaining so free variables update derivative variables.
			state.chainDependencies();
		}
		catch(err:Error) {
			view.statusMessage(err.toString(), 5000);
		}
		refresh();
		codeArea._visible = false;
		codeArea.setFocus();
		runButton.label = "Edit";
		//state.setColours();
	}
	
	function refresh():Void {
		codeArea.text = state.text;
		state.clearDrawPane();
	}
	
	function lTrim(s:String):String {
		var c:String = s.charAt(0);
		for(var i=0; i < s.length; i++) {
			var c:String = s.charAt(i);
			if(c != ' ' && c != '\r' && c != '\t') {
				break;
			}
		}
		return (i==s.length) ? "" : s.substr(i);
	}
	
	//
	// Tests
	//
	function typeIn(s:String):Void {
		if(codeArea.text.length > 0)
			codeArea.text += ("\r"+s);
		else
			codeArea.text += s;
	}
	function demo():Void {
		var view:ComplexView = this.view;
		var state:ComplexState = this.state;
		doLater(function(){
				view.setParameters(
						   {polarVisible:false,
						   polarCheckVisible:true, 
						   polarCheckSelected:false, 
						   cartesianVisible:false,
						   cartesianCheckVisible:true, 
						   cartesianCheckSelected:false}
						   );
			});
		typeIn("z=0");
		typeIn("w=z^2");
		typeIn("z paints 0xff0000");
		typeIn("z useKeys");
		typeIn("w drawLike z");
		typeIn("w paints 0x006666");	
		doLater(function(){
				view.setParameters(
						   {polarVisible:false,
						   polarCheckVisible:true, 
						   polarCheckSelected:false, 
						   cartesianVisible:false,
						   cartesianCheckVisible:true, 
						   cartesianCheckSelected:false,
						   dzVisible:false}
						   );
			});
	}
	function testMoebius1():Void {
		typeIn("psi = pi/8");
		typeIn("a=5");
		typeIn("b=a*~a");
		typeIn("A=exp(i*psi/2)*b+exp(-i*psi/2)");
		typeIn("B=2*i*a*sin(psi/2)");
		typeIn("z=1");
		typeIn("z paints 0x99");
		typeIn("z useKeys");
		//typeIn("z hide");
		typeIn("w=(A*z+B)/(-~B*z+~A)");
		typeIn("w drawLike z");
		typeIn("w paints 0x660066");
	}
	function graemeOctober():Void {
		var view:ComplexView = this.view;
		typeIn("p = 8");
		typeIn("p useMouse");
		typeIn("q = 100/~p");
		typeIn("q drawLike p");
		typeIn("q hideLabel");
		typeIn("p hideLabel");
		typeIn("p paints 0x880033")
		typeIn("q paints 0x000088");
		refreshButton._visible = true;
		runButton._visible = false;
	}
	function liz1October():Void {
		var view:ComplexView = this.view;
		typeIn("p = -13.7-19*i");
		typeIn("p useMouse");
		typeIn("q = ~p+275/10");
		typeIn("q drawLike p");
		typeIn("q hideLabel");
		typeIn("p hideLabel");
		typeIn("p paints 0x880033")
		typeIn("q paints 0x000088");
		typeIn("p constrain MazeA");
		var bg:MovieClip = view.addBackground("MazeAImage");
		bg._x = 275;
		trace("background = "+bg);
		doLater(function(){
				view.setParameters(
						   {polarVisible:false,
						   polarCheckVisible:false, 
						   polarCheckSelected:false, 
						   cartesianVisible:false,
						   cartesianCheckVisible:false, 
						   cartesianCheckSelected:false,
						   dzVisible:false}
						   );
				var q:Subject = state.getSubject("q");
				q.view.attachMovie("PointMask", "mask", 1, {_x:-38, _y:-38});
				bg.setMask(q.view["mask"]);
			});
		refreshButton._visible = true;
		runButton._visible = false;
	}
	function liz0October():Void {
		var view:ComplexView = this.view;
		var state:ComplexState = this.state;
		typeIn("p = 0");
		typeIn("p useMouse");
		typeIn("q = -p");
		typeIn("q drawLike p");
		typeIn("q hideLabel");
		typeIn("p hideLabel");
		typeIn("p paints 0x880033")
		typeIn("q paints 0x008888");
		typeIn("p constrain Tube");
		var bg:MovieClip = view.addBackground("TubeImage");
		//bg._x = 3;
		//bg._y = 35;
		bg._alpha=30;
		trace("background = "+bg);
		doLater(function(){
				view.setParameters(
						   {polarVisible:false,
						   polarCheckVisible:false, 
						   polarCheckSelected:false, 
						   cartesianVisible:false,
						   cartesianCheckVisible:false, 
						   cartesianCheckSelected:false,
						   dzVisible:false}
						   );
				var p:Subject = state.getSubject("p");
				p.view.attachMovie("PointMask", "mask", 1, {_x:-38, _y:-38});
				p.constraint.setMask(p.view["mask"]);
				var c:Color = new Color(p.constraint);
				c.setRGB(0xff8800);
				var q:Subject = state.getSubject("q");
				q.view._xscale = q.view._yscale = 200;
				//q.view.attachMovie("PointMask", "mask", 1, {_x:-38, _y:-38});
				//bg.setMask(q.view["mask"]);
			});
		refreshButton._visible = true;
		runButton._visible = false;
	}
	function testLogo() {
		var view:ComplexView = this.view;
		var state:ComplexState = this.state;
		typeIn("p = 0");
		doLater(function(){
				view.setParameters(
						   {polarVisible:false,
						   polarCheckVisible:false, 
						   polarCheckSelected:false, 
						   cartesianVisible:false,
						   cartesianCheckVisible:false, 
						   cartesianCheckSelected:false,
						   dzVisible:false}
						   );
						 }
		);
		//runButton._x = refreshButton._x + refreshButton.width;
	}
	function test():Void {
		draw();
		//demo();
		liz1October();
		//testLogo();
		run();
	}
}