﻿import mx.core.UIComponent;
import mx.managers.DepthManager;
import mx.controls.CheckBox;
import mx.controls.Label;
import mx.controls.TextArea;
import mx.controls.TextInput;
import Complex;
import ComplexView;
import Subject;
import SubjectView;
import SubjectPanel;
//import PathBuffer;
import PolarGrid;
import CartesianGrid;

class ComplexPlane extends UIComponent implements ComplexView {
	var origin:Complex;
	static var unit:Number;
	var polarCheck:CheckBox;
	var cartesianCheck:CheckBox;
	var dzInput:TextInput;
	var statusArea:TextArea;
	static var SW:Number = 550;
	static var SH:Number = 400;
	private var lowestFreePoint:MovieClip;
	private var _bounds:Object = null;

	private var polar : MovieClip;
	private var cartesian : MovieClip;
	private var checkBoxes:Object= {
			cartesianVisible : false,
			cartesianCheckVisible : false,
			cartesianCheckSelected : false,
			polarVisible : false,
			polarCheckVisible : false,
			polarCheckSelected : true,
			dzVisible:false
		};
	
	function ComplexPlane() {
		origin = new Complex(SW-SH/2, SH/2);
		origin = new Complex(SW/2, SH/2);
		unit = SH/40;

	}
	
	function bounds():Object {
		if(_bounds == null) {
			var tl:Complex = screenToComplex(new Complex(0));
			var br:Complex = screenToComplex(new Complex(SW,SH));
			_bounds = {xMin:tl.x, xMax:br.x, yMin:br.y, yMax:tl.y};
			//trace("bounds = "+_bounds.xMin+" "+_bounds.xMax+":"+_bounds.yMin+" "+_bounds.yMax);
		}
		return _bounds;
	}
	/*
	static var LEFT:Number = -20;
	static var RIGHT:Number = 550+20;
	static var TOP:Number = -20;
	static var BOTTOM:Number = 400+20;
	*/
	static var LEFT:Number = 0;
	static var RIGHT:Number = 550;
	static var TOP:Number = 0;
	static var BOTTOM:Number = 400;
	function onScreen(screen:Complex):Boolean {
		return (screen.x >= LEFT
				&& screen.x <= RIGHT
				&& screen.y >= TOP
				&& screen.y <= BOTTOM);
	}
	
	function reallyVisible(z:Complex):Boolean {
		var b:Object = bounds();
		return (z.x >= b.xMin 
				&& z.x <= b.xMax 
				&& z.y >= b.yMin 
				&& z.y <= b.yMax);
	}
	
	function allPointsVisible():Boolean {
		return false;
	}
	
	function draw():Void {
		if(statusArea == null) {
			statusArea = TextArea(createChildAtDepth("TextArea", DepthManager.kTop, {_x:150, _y:339, _width:390, _height:34, editable:"false", wordWrap:true}));
			statusArea._visible = false;
		}
		//
		if(polar == null) 
			drawPolar();
		if(cartesian == null)
			drawCartesian();
		if(polarCheck == null) {
			polarCheck = CheckBox(_parent.createChildAtDepth("CheckBox", DepthManager.kTop, {_x:450, _y:378, label:"polar", selected:checkBoxes.polarCheckSelected}));
			polarCheck.addEventListener("click", this);
			}
		if(cartesianCheck == null) {
			cartesianCheck = CheckBox(_parent.createChildAtDepth("CheckBox", DepthManager.kTop, {_x:350, _y:378, label:"cartesian", selected:checkBoxes.cartesianCheckSelected}));
			cartesianCheck.addEventListener("click", this);
		}
		if(cartesianCheck == null) {
			cartesianCheck = CheckBox(_parent.createChildAtDepth("CheckBox", DepthManager.kTop, {_x:350, _y:378, label:"cartesian", selected:checkBoxes.cartesianCheckSelected}));
			cartesianCheck.addEventListener("click", this);
		}

		if(dzInput == null) {
			var dzLabel:Label = Label(_parent.createChildAtDepth("Label", DepthManager.kTop, {_x:230, _y:378, text:"step"}));
			dzInput = TextInput(_parent.createChildAtDepth("TextInput", DepthManager.kTop, {_x:265, _y:375, text:"i"}));
			dzInput.setSize(80,22);
			dzInput.addEventListener("enter", this);
			dzLabel.visible = dzInput.visible = checkBoxes.dzVisible;
		}
		//
	}
	
	function enter(evt:Object) {
		trace("dzInput = "+dzInput.text);
		var e:Expression = new Expression(dzInput.text);
		var dz:Complex;
		try{
			if(e != null) {
				dz = deltaToScreen(e.evaluate());//.conjugate();
			}
			trace("dz ="+dz);
			dzInput.text = screenToDelta(dz).toString(); //.conjugate().toString();
			for(var id in ComplexState(Expression.state).subjects) {
				var s:Subject = Subject(ComplexState(Expression.state).subjects[id]);
				if(s.isFree()) {
					s.view.velocity = dz;
					s.view.onMove();
				}
			}
		}
		catch (error) {
		}
	}
	
	public function deltaToScreen(z:Complex):Complex {
		return z.conjugate().times(unit);
	}

	public function screenToDelta(z:Complex):Complex {
		return z.over(unit).conjugate();
	}

	
	// reset any global view properties
	function reset():Void {
		lowestFreePoint = null;
	}
	
	public function complexToScreen(z:Complex):Complex {
		return z.conjugate().times(unit).plus(origin);
	}

	public function screenToComplex(z:Complex):Complex {
		return z.minus(origin).over(unit).conjugate();
	}

	var messageId:Number = null;
	function statusMessage(msg:String, interval:Number):Void {
		statusArea.text = msg;
		statusArea._visible = true;
		messageId = setInterval(this, "clearMessage", interval);
	}
	
	function clearMessage():Void {
		statusArea.text = "";
		statusArea._visible = false;
		messageId = null;
	}
	
	public function createSubjectView(subject:Subject):Void {
		//trace("creating subject view on: " + subject); 
		var z:Complex = subject.evaluated;
		
		//trace("CP:113 subject: " + subject.id + " subject.evaluated = "+z);
		
		z = complexToScreen(z);
		//
		// TODO: distinguish the different kinds of subject here: (Point, Set ...)
		//
		var drawPane:MovieClip = createChildAtDepth("DrawPane", DepthManager.kTop, {_x:0, _y:0});
		subject.view = SubjectView(createChildAtDepth("Point", DepthManager.kTop, {_x:z.x, _y:z.y, subject:subject, drawPane:drawPane}));
		if(lowestFreePoint == null && subject.isFree()) {
			lowestFreePoint = subject.view;
			//trace("lowestFreePoint = " + subject.id + " depth="+subject.view.getDepth());
		}
		if(!subject.isFree()) {
			//
			// Following typecast is necessary for the setDepthBelow add-in (weird)
			// 
			(MovieClip(subject.view)).setDepthBelow(lowestFreePoint);
			//trace("setting " + subject.id + " below " + lowestFreePoint.getDepth()+ " depth="+subject.view.getDepth());
		}
	}
	
	public function createSubjectConstraint(subject:Subject, id:String):Constraint {
		var point:Complex = complexToScreen(subject.getValue());
		var c:Constraint = Constraint(createChildAtDepth(id, DepthManager.kBottom, {_x:0,_y:0,insidePoint:point}));
		return c;
	}
	
	public function addBackground(id:String):MovieClip {
		var c:MovieClip = MovieClip(createChildAtDepth(id, DepthManager.kBottom, {_x:0,_y:0}));
		return c;		
	}
	
	public function setParameters(object:Object):Void {
		checkBoxes = object;
				
		polar._visible = object.polarVisible;
		polarCheck.visible = object.polarCheckVisible;
		polarCheck.selected = object.polarCheckSelected;
		cartesian._visible = object.cartesianVisible;
		cartesianCheck.visible = object.cartesianCheckVisible;
		cartesianCheck.selected = object.cartesianCheckSelected;
	}
	

	function click(evt:Object) {
		switch(evt.target) {
			case polarCheck:
				polar._visible = polarCheck.selected;
				break;
			case cartesianCheck:
				cartesian._visible = cartesianCheck.selected;
				break;
			default:
				trace("unknown click in CartesianPlane");
		}
		setFocus(this);
	}
	
	//
	// Private from here
	//
	private function drawPolar():Void {
		//trace("drawPolar");
		var radius:Number = (SW - Math.min(origin.length, SW-origin.length))/unit;
		polar = attachMovie("PolarGrid", "polar", 1, {radius:radius});
		//polar = createChildAtDepth("PolarGrid", DepthManager.kTop, {radius:radius});
		polar.draw();
		polar.cacheAsBitmap = false;
		
	}

	private function drawCartesian():Void {
		//trace("drawCartesian");
		//var radius:Number = SW - Math.min(origin.length, SW-origin.length);
		var xMax = (SW-origin.x)/unit;
		var xMin = -origin.x/unit; 
		var yMax = (SH-origin.y)/unit;
		var yMin = -origin.y/unit; 
		cartesian = attachMovie("CartesianGrid", "cartesian", 2, {xMin:xMin, xMax:xMax, yMin:yMin, yMax:yMax});
		cartesian.draw();
		cartesian.cacheAsBitmap = false;
	}

}