﻿import mx.events.EventDispatcher;
//import mx.utils.Delegate;
import Complex;
import PrimitiveSet;
import Expression;
import Commands;
import State;

//
// Use this class to define the commands understood by Expression syntax and to store
// any defined variables.
//
// The base implementation is useful when you don't need to track geometric views or
// any metadata that may be associated with an Expression. 
//


class BasicStateImpl extends EventDispatcher implements State {
	var variables:Object = {};
	var cache:Object = {};
	var commands:Commands;
	
	function BasicStateImpl() {
		//trace("BasicStateImpl:24: new BasicStateImpl()");
		variables = {};
		cache = {}; // value cache
		commands = new Commands();
		Expression.state = this;
		Expression.classInit();
		Complex.classInit();
		PrimitiveSet.classInit();
	}
	
	//
	// TODO:
	//
	// Delegate commands to the subject of the command.
	//
	
	public function executeCommand(name:String, varName:String, expr1:Expression):Complex {
		var cmd:Function = Function(commands[name]);
		if(cmd == null) {
			throw new Error("Invalid command: " + name);
		}
		var rv:Complex = cmd(varName, expr1);
		return (rv == null) ? new Complex(varName + " " + name + expr1) : rv;
	}
	
	public function commandDisplayName(name:String):String {
		return commands[name].displayName;
	}
	
	public function hasCommand(name:String):Boolean {
		return commands[name] instanceof Function;
	}
	
	public function reset():Void {
		//trace("BasicStateImpl: 49: reset()");
		variables = {};
		cache = {};
	}
	
	public function setValue(varName:String, value:Complex):Void {
		cache[varName] = value;
	}
	
	public function getValue(varName:String):Complex {
		//trace("BasicStateImpl:55 var " + varName + " = " + Complex(cache[varName]));
		return Complex(cache[varName]);
	}
	
	public function define(varName:String, rvalue:Expression):Complex {
		variables[varName]=rvalue;
		return revalue(varName).current;
		//trace("BasicStateImpl:69 defining " + varName + "=" + rvalue);
	}
	
	public function getDefinition(varName:String):Expression {
		return Expression(variables[varName]);
	}
	
	public function revalue(varName:String):Object {
		var prev:Object = cache[varName];
		return {prev:prev, current: cache[varName]=Expression(variables[varName]).evaluate()};
	}
	
	public function setColor(lvalue:Expression, rvalue:Expression):Void {
	}

}