﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.containers.ScrollPane;
import mx.controls.Label;
import mx.controls.NumericStepper;
import mx.controls.Button;
import mx.managers.DepthManager;
import LogoFunction;
import Popup;

// Event metadata tag 
class TurtleGraphics extends Popup {

	static var symbolName:String = "TurtleGraphics";
	static var symbolOwner:Object = TurtleGraphics;
	var className:String = "TurtleGraphics";

	var content:MovieClip;
	
	private var __x:Number = 0;
	private var __y:Number = 0;
	private var __h:Number = 0;
	var penDown:Boolean = true;
	var turtle:MovieClip;
	var drawPane:MovieClip;
	
	private var __stepTime:Number = 0;
	private var __turnTime:Number = 0;	
	private var __thickness:Number = 2;
	private var __rgb:Number = 0;
	private var __alpha:Number = 80;
	
	static var N = LogoFunction.NUMBER;
	static var B = LogoFunction.BOOLEAN;
	static var W = LogoFunction.WORD;
	static var L = LogoFunction.LIST;
	static var WoL = LogoFunction.WORDorLIST;
	static var O = LogoFunction.OBJECT;

	var pane:ScrollPane;
	var clear_btn:Button;
	var speedLabel:Label;
	var speedStepper:NumericStepper;
	var pause_btn:Button;
	
	private var _logo:Evaluator;
	
	public function init() {
		super.init();
	}
	
	// Overide all textBox functions...
	public function createTextBox():Void {}
	public function drawTextBox():Void {}
	public function sizeTextBox():Void {}
	public function get code():String {return null;}
	public function set code(s:String):Void {}
	
	// And replace them with TurtlePane functions...
	public function createTurtlePane():Void {
		pane = ScrollPane(createClassChildAtDepth(ScrollPane, DepthManager.kTop,{_x:5,_y:20}));
		pane.setSize(width-10,height-25);
		pane.contentPath = "Screen";
		doLater(this, "initScreen");
	}
	
	public function initScreen():Void {
		content = pane.content;
		drawPane = content.drawPane;
		turtle = content.attachMovie("Turtle", "turtle", 1,{_alpha:40});
		home();
		drawPane.lineStyle(__thickness, __rgb, __alpha);
		pane.scrollDrag = true;
		centreTurtle();
		clearscreen();
		addTurtlePrimitives(_logo.functions);
	}
	
	public function centreTurtle():Void {
		pane.hPosition = tx-pane.width/2;
		pane.vPosition = ty-pane.height/2;
	}
	
	// But we do need a TurtleGraphics Window
	public function createChildren():Void {
		
		super.createChildren();
		
		createTurtlePane();
		
		clear_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:5,_y:pane._y+pane.height+5}));
		clear_btn.setSize(50,22);
		clear_btn.label = "Clear";
		clear_btn.tabIndex = 2;
		clear_btn.addEventListener("click", this);
		
		speedLabel = Label(createClassChildAtDepth(Label, DepthManager.kTop,{_x:clear_btn._x+clear_btn.width+10,_y:pane._y+pane.height+7}));
		speedLabel.setSize(50,22);
		speedLabel.autoSize = "right";
		speedLabel.text = "Speed";
		
		speedStepper = NumericStepper(createClassChildAtDepth(NumericStepper, DepthManager.kTop,{_x:speedLabel._x+speedLabel.width+5,_y:pane._y+pane.height+5}));
		speedStepper.setSize(40,18);
		speedStepper.maximum = 10;
		speedStepper.minimum = 1;
		speedStepper.value = 10;
		speedStepper.tabIndex = 4;
		speedStepper.addEventListener("change", this);
		
		pause_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:speedStepper._x+speedStepper.width+5,_y:pane._y+pane.height+5}));
		pause_btn.setSize(66,22);
		pause_btn.label = "Pause";
		pause_btn.tabIndex = 3;
		pause_btn.addEventListener("click", this);
		
		minWidth = Math.max(minWidth, 5+pause_btn._x+pause_btn.width);
		
		size();
	}

	function draw():Void {
		super.draw();
		clear_btn.visible = pause_btn.visible = pane.visible = speedLabel.visible = speedStepper.visible = !minimised;
		pause_btn.visible &= _logo.scheduler.running;
	}

	function size():Void {
		super.size();
		pane.setSize(width-10,height-50);
		clear_btn.move(5,pane._y+pane.height+5);
		speedLabel.move(clear_btn._x+clear_btn.width+5, pane._y+pane.height+5);
		speedStepper.move(speedLabel._x+speedLabel.width+5, pane._y+pane.height+5);
		pause_btn.move(speedStepper._x+speedStepper.width+5, pane._y+pane.height+5);
	}

	//
	// Button clicks come in here
	//
	public function click(evt){
		switch(evt.target) {
			case clear_btn: 
				// Update the member variables with the input field contents.
				clearscreen();
				break;
			case pause_btn: 
				// Update the member variables with the input field contents.
				if(pause_btn.label == "Pause") {
					trace("Pause");
					_logo.scheduler.pause();
					pause_btn.label = "Resume";
					
				}
				else {
					trace("Continue");
					_logo.scheduler.resume();
					pause_btn.label = "Pause";
				}
				break;
		}
	}

	public function logoRunning() {
		pause_btn.label = "Pause";
		pause_btn.visible = true;
	}
	
	public function logoPaused() {
		pause_btn.label = "Resume";
		pause_btn.visible = true;
	}
	
	public function logoStopped() {
		pause_btn.label = "Pause";
		pause_btn.visible = false;
	}
	
	// Speed change
	public function change(evt) {
		__stepTime = 2*(10-speedStepper.value);
		__turnTime = __stepTime/3;
	}
	
	// setters and getters
	function set evaluator(logo:Evaluator):Void {
		_logo = logo;
		_logo.scheduler.addEventListener("logoStopped", this);
		_logo.scheduler.addEventListener("logoRunning", this);
		_logo.scheduler.addEventListener("logoPaused", this);
		
	}
	
	//
	// Turtle graphics code start here
	//
	
	function clearscreen():Void {
		//trace("turtle clearscreen");
		bringToFront();
		if(minimised) minimised = false;
		drawPane.clear();
		home();
		drawPane.moveTo(tx,ty);
		if(penDown) {
			drawPane.lineStyle(__thickness, __rgb, __alpha);
		}
		//turtle._visible = true;
	}

	function forward(n):Void {
		//trace("turtle forward:"+n);
		var theta = this.h * Math.PI / 180;
		tx += n * Math.sin(theta);
		ty += -n * Math.cos(theta);
		  		
		if (penDown) {
			//trace("lineTo");
			drawPane.lineTo(tx, ty);
		}
	}
	
	function animateForward(n:Number, duration:Number, k:Function):Void {
		var theta = this.h * Math.PI / 180;
		var xstep = n * Math.sin(theta);
		var ystep = -n * Math.cos(theta);
		var tx0:Number = tx;
		var ty0:Number = ty;
		//trace("turtle forward:"+n + " xstep="+xstep);
		var stepForward:Function = function(tt):Void {
			tx = tx0 + tt*xstep;
			//trace('tt='+tt+' tx='+tx + ' xstep='+xstep);
			ty = ty0 + tt*ystep;
			if (penDown) {
				//trace("lineTo");
				drawPane.lineTo(tx, ty);
			}
		}
		//trace("stepForward="+stepForward);
		animate(duration, stepForward, k);
	}
	
	//
	// Usage: animate(duration, fn, arg1, arg2,...)
	// For duration ms, call fn(t,arg1,arg2...) every duration/tickLength seconds.
	// t increases from 0 to 1 during duration.
	//
	function animate(duration:Number, fn:Function, k:Function) {
		var self:Object = this;
		var tickLength = 30; // milliseconds
		var t:Number = 0;
		var intervalId:Number = 0;
		var startTime:Number = getTimer();
		var lastTime:Number = startTime+tickLength;
		var targetTime = getTimer() + duration;
		var lastTickLength = tickLength;
		var animator:Function = function(k):Void {
			t += tickLength;
			var time:Number = getTimer();
			lastTickLength = lastTickLength*0.1 +(time - lastTime)*0.9;
			lastTime = time;
			if(time + lastTickLength > targetTime) {
				fn.call(self, 1);
				clearInterval(intervalId);
				//trace('k='+k+" self="+self + " functions="+self._logo.functions.name);
				self._logo.scheduler.running = true;
				self._logo.scheduler.run(self._logo, k);
				//self._logo.scheduler.delay(1,k); //cont(k);//k.call(self._logo.functions);
			}
			else {
				fn.call(self, (time-startTime)/duration);
				//trace(lastTickLength);
			}
		}
		intervalId = setInterval(animator, tickLength, k);
	}

	function turn(n:Number):Void {
		//trace("turtle right:"+n);
		h += n;
		if(h > 180) h-=360;
		turtle._rotation = h;
	}

	function animateTurn(n:Number, duration:Number, k:Function):Void {
		var h0:Number = h;
		//trace("turtle forward:"+n + " xstep="+xstep);
		var stepTurn:Function = function(tt):Void {
			h = h0 + tt*n;
			if(h > 180) h-=360;
			turtle._rotation = h;
		}
		//trace("stepForward="+stepForward);
		animate(duration, stepTurn, k);
	}
	
	function penup():Void {
		//trace("turtle penup");
		penDown = false;
	}

	function pendown():Void {
		//trace("turtle penDown");
		penDown = true;
	}

	function hideturtle():Void {
		//trace("turtle hide");
		turtle._visible = false;
	}

	function showturtle():Void {
		//trace("turtle show");
		turtle._visible = true;
	}

	function addTurtlePrimitives(ns:Object):Void {
		var self = this;
		
		ns.cs = ns.clearscreen = new LogoFunction(
			"cs", 
			[], 
			false,
			function(k) {
				self.clearscreen();
				k();
			});
		
		ns.fd = ns.forward = new LogoFunction(
			"fd", 
			[N], 
			false,
			function(k, n) {
				if(self.__stepTime <= 0) {
					self.forward(n);
					k();
				}
				else {
					self.animateForward(n,n*self.__stepTime, k);
					//this.wait.fn.call(this, k, (n+20)*self.__stepTime);
				}
			});

		ns.bk = ns.back = new LogoFunction(
			"bk", 
			[N], 
			false,
			/*
			function(k, n) {
				self.forward(-n,n*5);
				this.wait.fn.call(this, k, n*15);
			});
			*/
			function(k, n) {
				if(self.__stepTime <= 0) {
					self.forward(-n);
					k();
				}
				else {
					self.animateForward(-n,n*self.__stepTime, k);
					//this.wait.fn.call(this, k, (n+20)*self.__stepTime);
				}
			});

		ns.rt = ns.right = new LogoFunction(
			"rt", 
			[N], 
			false,
			/*
			function(k, n) {
				//trace("right " + n);
				self.turn(n);
				k();
			});
		    */
			function(k, n) {
				if(self.__stepTime <= 0) {
					self.turn(n);
					k();
				}
				else {
					self.animateTurn(n,n*self.__turnTime, k);
					//this.wait.fn.call(this, k, (n+20)*self.__turnTime);
				}
			});

		
		ns["lt"] = ns.left = new LogoFunction(
			"lt", 
			[N], 
			false,
			/*
			function(k, n) {
				self.turn(k, 360-n);
				k();
			});
			*/
			function(k, n) {
				if(self.__stepTime <= 0) {
					self.turn(-n);
					k();
				}
				else {
					self.animateTurn(-n, n*self.__turnTime, k);
					//this.wait.fn.call(this, k, (n+20)*self.__turnTime);
				}
			});

		ns.pu = ns.penup = new LogoFunction(
			"pu", 
			[], 
			false,
			function(k) {
				self.penup();
				k();
			});

		ns.pd = ns.pendown = new LogoFunction(
			"pd", 
			[], 
			false,
			function(k) {
				self.pendown();
				k();
			});

		ns.ht = ns.hideturtle = new LogoFunction(
			"ht", 
			[], 
			false,
			function(k) {
				self.hideturtle();
				k();
			});

		ns.st = ns.showturtle = new LogoFunction(
			"st", 
			[], 
			false,
			function(k) {
				self.showturtle();
				k();
			});

		ns.setpc = ns.setpencolor = ns.setpencolour = new LogoFunction(
			"setpencolour", 
			[L], 
			false,
			function(k, rgba) {
				var r:Number = self.getColour(rgba[0]);
				var g:Number = self.getColour(rgba[1]);
				var b:Number = self.getColour(rgba[2]);
				self.rgb = b + (g << 8) + (r << 16);
				//trace("rgb = "+self.rgb.toString(16));
				if(rgba.length >= 4) {
					self.alpha = getColour(rgba[3])*100/256;
				}
				k();
			});
		
		ns.setps = ns.setpensize = new LogoFunction(
			"setpensize", 
			[N], 
			false,
			function(k, t) {
				self.thickness = t;
				k();
			});

		ns.setx = new LogoFunction(
			"setx", 
			[N], 
			false,
			function(k,n) {
				self.tx = n;
				k();
			});
		
		ns.sety = new LogoFunction(
			"sety", 
			[N], 
			false,
			function(k,n) {
				self.ty = n;
				k();
			});
		
		ns.setxy = new LogoFunction(
			"setxy", 
			[N,N], 
			false,
			function(k,nx,ny) {
				self.ty = nx;
				self.ty = ny;
				k();
			});
		   
		ns.xpos = new LogoFunction(
			"xpos", 
			[], 
			false,
			function(k) {
				k(self.tx);
			});
		
		ns.ypos = new LogoFunction(
			"ypos", 
			[], 
			false,
			function(k) {
				k(self.ty);
			});
		
		ns.heading = new LogoFunction(
			"heading", 
			[], 
			false,
			function(k) {
				k(self.h);
			});
		
		ns.setspeed = new LogoFunction(
			"setspeed", 
			["1:10"], 
			false,
			function(k, n) {
				trace("Set Speed");
				self.speed = n;
				k();
			});
		
		ns.speed = new LogoFunction(
			"speed", 
			[], 
			false,
			function(k, n) {
				k(self.speed);
			});
		
	}
	
	
	//
	// Utilities and Setter/Getters
	//
	function home() {
		tx = drawPane._width/2;
		ty = drawPane._height/2;
		//trace("tx,ty="+turtle._x+","+turtle._y);
		h = 0;
	}
		
	// Setters and Getters
	function set speed(n:Number):Void {
		speedStepper.value = n;
		__stepTime = 2*(10-speedStepper.value);
	}
	
	function get speed():Number {
		return Math.round(10 - __stepTime/2);
	}
	
	function set tx(n:Number):Void {
		__x = n;
		turtle._x = n;
	}
	function get tx():Number {
		return __x;
	}
	function set ty(n:Number):Void {
		__y = n;
		turtle._y = n;
	}
	function get ty():Number {
		return __y;
	}

	function get h():Number {
		return __h;
	}
	function set h(n:Number):Void {
		__h = n;
		turtle._rotation = __h;
	}
	function set rgb(n:Number):Void {
		__rgb = n;
		drawPane.lineStyle(__thickness, __rgb, __alpha);
	}
	function get rgb():Number {
		return __rgb;
	}
	
	function set alpha(n:Number):Void {
		__alpha = n;
		drawPane.lineStyle(__thickness, __rgb, __alpha);
	}
	function get alpha():Number {
		return __alpha;
	}
	
	function set thickness(n:Number):Void {
		__thickness = n;
		drawPane.lineStyle(__thickness, __rgb, __alpha);
	}
	function get thickness():Number {
		return __thickness;
	}
	
	function getColour(obj:Object):Number {
		var n:Number = Number(obj);
		if(n==null || isNaN(n) || n < 0) {
			return 0;
		}
		if(n > 255) {
			return 255;
		}
		return Math.round(n);
	}
	
}