﻿Array.prototype.toString = function()
{
     var str = "";
     for(var i =0; i < this.length; i++)
       str = str + " " + this[i];
     return str;
}

function Transcript(div) {
  if (typeof div == 'string')
	  this.element = document.getElementById(div);
	else 
	  this.element = div;
	this.contents = [];
	this.limit = 5;
}

Transcript.prototype.addPrimitives = function(obj) {
	var self = this;

	obj.print = function(k, word) {
		self.print(word);
		k()
	}
    
    var oldCs = obj.clearscreen;	
	obj.clearscreen = function() {self.clear();}
}

Transcript.prototype.clear = function() { 
	this.contents = [];
	this.update();
}

Transcript.prototype.print = function(line) {
	this.contents.push(line);
	if (this.contents.length > this.limit)
		this.contents.shift();
	this.update();
}

Transcript.prototype.update = function(update) {
	html = '';
	for (var i=0; i<this.contents.length; i++) {
		html += this.contents[i];
		html += "<br />";
	}
	this.element.innerHTML = html;
}