﻿class Reader {
	
	//
	// This isn't fixable. Need a proper parser. Things that are impossible to do right using this
	// kind of logic are:
	//		devise a precedence scheme for */ over +-
	//		handle unary minus
	//
	
	
	// Bug: transpose (infix to prefix conversion) does not respect parentheses
	// (1)
	// make "n (2 * :n) + 5
	// > (make "n ( * 2 :n + ) 5)
	//
	// (2)
	// User must delimit binops with spaces in current configuration
	// The simple fix of making binops separators so they pad themselves fails to cope
	// with unary minus. (5 + -3) -> (5 + - 3) and transposes to (+ 5 - 3) and finally (+ - 5 3) 
	//

	var functions:Object;
	var list:Array;
	// WARNING: The following array is ordered in order to help resolve unary minus/difference ambiguity
	// The order is:
	//	(1) operators that need numeric input. These will generate the spaces needed by (2)
	//  (2) ' -' - which is interpreted as unary minus unless it is also followed by a space
	//  (3) '-' - since we couldn't include it before
	//  (4) the rest
	//
	//  Yuk! Give me regular expressions!
	//
	var separators = ["+","*","/","=","<",">"," -","--","-","[","]","(",")"];
	//var separators = ["[","]","(",")"];
	
	function Reader(functions:Object) {
		this.functions = functions;
	}
	
	public function read(str):Array {
		list = singleSpace(padSeparators(standardiseSpace(removeComments(str))));
		//trace("SS: " + list);
		list = readOnce(list);
		//trace("RO: " + list);
		//list = fixPrecedence(list);
		//trace("FP: " + list);
		list = transpose(list);
		//trace("TP: " + list);
		list = flattenPars(list);
		//trace("PP: " + list);
		if(list[0] instanceof Array && list[0].length == 1)
			return list[0];
		else
			return list;
	}
	
	private function replaceAllWith(s:String, pattern:String, substitute:String):String {
		var x = 0;
		while((x = s.indexOf(pattern,x)) >= 0) {
			//trace(pattern + ".length=" + pattern.length);
			s=s.slice(0,x)+substitute+s.slice(x+pattern.length);
			x += substitute.length;
		}
		return s;
	}
	
	private function replaceAllWithIf(s:String, pattern:String, substitute:String):String {
		var x = 0;
		while((x = s.indexOf(pattern,x)) >= 0) {
			//trace(pattern + ".length=" + pattern.length);
			var t = s.charAt(x+pattern.length);
			if(t!=" " && t != "-") {
				s=s.slice(0,x)+substitute+s.slice(x+pattern.length);
				x += substitute.length;
			}
			else 
				x += pattern.length;
		}
		return s;
	}
	
	private function standardiseSpace(s:String):String {
		// change all whitespace to ' '
		s = replaceAllWith(s, '\r', ' ');
		s = replaceAllWith(s, '\n', ' ');
		s = replaceAllWith(s, '\t', ' ');
		//trace("IN:" + s);
		return s;
	}
	
	private function removeComments(s:String):String {
		var rv:String = s
		var scx:Number = -1;
		while((scx=rv.indexOf(";")) >= 0) {
			var eolx:Number = rv.indexOf("\r", scx);
			if(eolx < 0) {
				rv = rv.slice(0,scx);
				break;
			}
			else {
				rv = rv.slice(0,scx)+rv.slice(eolx+1);				
			}
		}
		return rv;
	}
	
	private function padSeparators(s:String):String {
		var rv:String = s;
		for(var i=0; i < separators.length; i++) {
			var x:Number = 0;
			var sep:String = separators[i];
			if(sep == ' -') {
				s = replaceAllWithIf(s, sep, (" minus "));
			}
			else if(sep == '--') { 
				s = replaceAllWith(s, sep, (" - minus "));
			}
			else { 
				s = replaceAllWith(s, sep, (" "+sep+" "));
			}
		}
		return s;
	}
	
	public function singleSpace(s:String):Array {
		var r:Array =[];
		var a:Array = s.split(" ");
		for(var i=0; i < a.length; i++) {
			if(a[i]!="" && a[i]!=null) {
				r.push(a[i]);
			}
		}
		return r;
	}
		
	public function readOnce(list:Array):Array {
	   var result = [];
		while(list.length > 0) {
			var listItem = list.shift();
			if(listItem != null && listItem.length > 0) {
				if(listItem == "[")
					result.push(readOnce(list));
				else if(listItem == "]" || listItem == ")")
					return result;
				else if(listItem == "(") {
					var pList = readOnce(list);
					pList.inParenthesis = true;
					result.push(pList);
				}
				// TODO: test following else {} 
				/*
				else if(listItem=="minus") {
					var plist = [listItem, readOnce(list)[0]];
					result.push(plist);
				}
				*/
				else if(!isNaN(listItem))
					result.push(Number(listItem));
				else
					result.push(listItem.toString());
			}
		}
		return result;
	}
	
	public function fixPrecedence(list:Array):Array {
		var result = [];
		result.inParenthesis = list.inParenthesis;
		for(var i = 0; i < list.length; i++) {
			var each = list[i];
			if(each == '*' || each == '/') {
				// make a parenthesised list {a*b} or {a/b}
				var a = result.pop();
				var par:Array = [a, each, list[++i]];
				par.inParenthesis = true;
				result.push(par);
			}
			else {
				result.push(each);
			}
		}
		return result;
	}
	
	public function transpose(list:Array):Array {
		var result = [];
		result.inParenthesis = list.inParenthesis;
		for (var i=0; i<list.length; i++) {
			var each = list[i];
			if(each instanceof Array) {
				each = transpose(each);
			}
			// following line eliminates null items caused by double spaces
			else if (each.length == 0) continue;
			// change arithmetic operators from infix to prefix notation
			// (a + b) -> (+ a b)
			else if (String("+*/-=<>").indexOf(each)>=0) {
				var t = result.pop();
				if(t == null) {
					if(each == "-") {
						result.push("minus");
						continue;
					}
					else {
						trace("t==null syntax error");
					}
				}
				if(each == "-" && isNaN(list[i-1]) && !isNaN) {
					//trace("t="+t);
					result.push(t);
					result.push(each);
					continue;
				}
				result.push(each);
				each = t;
			}
			result.push(each);
		}
		return result;
	}
	
	//
	// I have a feeling that Reader.flattenPars and Evaluator.callParenthesis could be simplified
	//
	private function flattenPars(list:Array):Array {
		var result = [];
		for (var i=0; i<list.length; i++) {
			var each = list[i];
			if(each.inParenthesis) {
				result = result.concat("(", flattenPars(each), ")");
				continue;
			}
			else if(each instanceof Array) {
				result.push(flattenPars(each));
			}
			else
				result.push(each);
		}
		return result;
	}
	
}
