﻿//
// Logo functions are the data structures which support both primitive and user defined functions
// of the logo language.
//
// Copyright: University of Cambridge
// Author:	 gmp26@cam.ac.uk
//
// All rights reserved.
//
class LogoFunction extends Function {
	
	// Logo name of function
	var name:String;
	
	// Parameter schema - an array of parameter types - it wraps for variable length args
	var params:Array; // array of strings
	
	// True if (function arg1 arg2 ... argn) syntax is allowed for any n
	var variableLength:Boolean=false;
	
	// The AS2 function to call
	var fn:Function;
	
	// In a user defined function, an array of dummy parameter names. Null in a primitive function.
	var logoArguments:Array;
	
	// Whether or not the function is traced
	var traced:Boolean = false;
	
	static var WORD:String = "W";
	static var NUMBER:String = "N";
	static var BOOLEAN:String = "B";
	static var LIST:String = "L";
	static var WORDorLIST:String = "WoL";
	static var OBJECT:String = "O";
	
	function LogoFunction(name:String, params:Array, variableLength:Boolean, fn:Function, logoArguments:Array) {
		this.name = name;
		this.params = params;
		this.variableLength = (variableLength == true); 
		this.fn = fn;
		this.logoArguments = logoArguments;
	}
	
	function apply(thisObject:Object, all:Array):Object {
		//trace("LogoFunction.apply " + thisObject.name + " " + all);
		return fn.apply(thisObject, all);
	}
	
	function call(thisObject:Object):Object {
		//trace("LogoFunction.call " + thisObject.name + " " + arguments);
		return fn.apply(thisObject, arguments);
	}
	
	function traceMessage(args):String {
		return Transcript.showString([name].concat(args), true); //.toString();
	}
	
	function argumentError(args:Array):String {
		if(!variableLength && params.length != args.length) {
			return name + " wants " + logoArity + " parameters, but saw " + args.length;
		}
		for(var i = 0; i < args.length; i++) {
			var a:Object = args[i];
			var ok:Boolean=false;
			var colonx:Number = -1;
			//trace(name + "["+i+"] expects " + params[i % params.length] + " sees " + a + ":"+(typeof a));
			
			var p:String = params[i % params.length];
			switch(p.charAt(0)) {
				case NUMBER:
					ok = typeof a == "number";
					break;
				case BOOLEAN:
					ok = typeof a == "boolean";
					break;
				case WORD:
					ok = typeof a == "string";
					break;
				case LIST:
					ok = a instanceof Array;
					break;
				case OBJECT:
					ok = true;
					break;
			}
			if (!ok) {
				if(p==WORDorLIST) {
					ok = (typeof a == "string") || (a instanceof Array);
				}
				else if ((colonx = p.indexOf(':')) >= 0) {
					//Numeric range
					var inf:Number = Number(p.slice(0,colonx));
					var sup:Number = Number(p.slice(colonx+1));
					ok = (isNaN(inf) || a >=inf) && (isNaN(sup) || a <= sup)
					/*
					if(isNaN(inf) || isNaN(sup)) {
						trace('Bad range spec in '+name);
					}
					ok = (a >= inf) && (a <= sup);
					*/
				}
			}

			if(!ok) {
				return name + " doesn't like " + a + " as input";
			}
		}
		return null;
	}
	
	function get logoArity():Number {
		//
		// return number of parameters expected or null
		// null implies a variable number are allowed
		//
		return /*variableLength ? null : */ params.length;
	}
}