﻿class Letter extends MovieClip {
	var x0:Number;
	var y0:Number;
	var grid:MovieClip;
	static var top:Letter;
	
	function Letter() {
		//trace("You have just made " + this);
		x0=_x;
		y0=_y;
		top = this;
		
		// make sure onRelease is always called on mouseUp
		onReleaseOutside = onRelease;
		
		// save a shortcut pointer to the grid
		grid = _root.grid;
	}
	
	function reset() {
		_x=x0; 
		_y=y0;
	}
	
	function onPress() {
		//trace("You pressed me");
		this.startDrag();
		swapDepths(top);
		top = this;
	}
	
	function onRelease() {
		//trace("You released me");
		this.stopDrag();
		_x = grid.snapx(_x);
		_y = grid.snapy(_y);
		
		//
		// Check that the returned snap coordinates are inside the grid
		// '||' means 'or' here
		//
		if(_x < grid._x 
		   || _x > grid._x + grid._width
		   || _y < grid._y
		   || _y > grid._y + grid._height) {
			// we snapped to a point outside the grid
			// so put the letter back in home position
			//trace("snap is outside grid, I'm sending the letter home");
			reset();
		}
		
		//trace("grid is returning: " + _x + " " + _y);
	}
}
