﻿class Coord extends MovieClip {
	
	// These store references to the Points we drew on the grid.
	// We use these to work out how to snap.
	var p00:MovieClip;
	var p33:MovieClip;
	var originx:Number;
	var originy:Number;
	
	// unitx is the number of pixels in one unit in the x direction
	var unitx:Number;

	// unity is the number of pixels in one unit in the y direction
	var unity:Number;
	
	// Constructor function
	function Coord() {
		// initialise our variables from the drawn grid.
		var p00:MovieClip = this["p00"];
		var p33:MovieClip = this["p33"];
		
		// Find the position of p00 relative to _roots origin (top left of screen)
		// p00._x is measured from 'this' top-left. i.e. _root.grid top-left. 
		originx = _x + p00._x;
		originy = _y + p00._y;
		
		unitx = (p33._x - p00._x)/3;
		unity = (p33._y - p00._y)/3;
		
		//trace("unitx = " + unitx);
		//trace("unity = " + unity);
	}
	
	//
	// Given x - a horiz distance from _root top-left, return an x on the nearest grid line.
	// When called, x will contain the x coordinate of the centre of a letter relative to _root top-left.
	// Our answer must also be relative to _root top-left.
	//
	function snapx(x:Number):Number {
		
		// localx is how many pixels x is from grid top-left
		var localx:Number = x - originx;
		
		// coordx is how many units x is from grid top left
		// It will not normally be an integer unless we happened to land on a grid line.
		var coordx:Number = localx / unitx;
		
		// let's see what's happening...
		trace("original x = " + x + " localx = " + localx + " coordx = " + coordx + " unitx = " + unitx);
		
		// round it off to the nearest integer; this is where the snap happens
		coordx = Math.round(coordx);
		
		// Convert back to pixels (relative to grid top-left)
		localx = coordx*unitx;
		
		// Calculate pixels from _root top-left
		x = originx + localx;
		
		// let's see what we have calculated...
		trace(" snapped x = " + x + " localx = " + localx + " coordx = " + coordx);

		// and that's the x value we need to give back
		return x;
	}
	
	//
	// Given y - a horiz distance from _root top-left, return an y on the nearest grid line.
	// When called, y will contain the y coordinate of the centre of a letter relative to _root top-left.
	// Our answer must also be relative to _root top-left.
	//
	function snapy(y:Number):Number {
		
		// localy is how many pixels y is from grid top-left
		var localy:Number = y - originy;
		
		// coordy is how many units y is from grid top left
		// It will not normally be an integer unless we happened to land on a grid line.
		var coordy:Number = localy / unity;
		
		// let's see what's happening...
		//trace("original y = " + y + " localy = " + localy + " coordy = " + coordy + " unity = " + unity);
		
		// round it off to the nearest integer; this is where the snap happens
		coordy = Math.round(coordy);
		
		// Convert back to pixels (relative to grid top-left)
		localy = coordy*unity;
		
		// Calculate pixels from _root top-left
		y = originy + localy;
		
		// let's see what we have calculated...
		//trace(" snapped y = " + y + " localy = " + localy + " coordy = " + coordy);

		// and that's the y value we need to give back
		return y;
	}
}
