﻿import mx.managers.DepthManager;
import mx.core.UIComponent;
import Expression;
import Complex;
import Subject;
//
// This is the View of the {Subject, SubjectView, SubjectPanel} MVC triplet.
// operating in conjunction with {ComplexState, ComplexView, Console} 
//
class SubjectView extends MovieClip {
	var subject:Subject;
	var pressPoint:Complex;
	var snapRadius:Number = 3;
	var color:Color;
	var subLabel:MovieClip;
	
	function SubjectView() {
		color = new Color(this);
		createSubjectPanel();
		createLabel();
		//trace("subject " + subject.id + " is free? " + subject.definition.isFreePoint());
		if(subject.isFree()) {
			rgb=0xff0000;
		}
	}
	
	function draw() {
		color = new Color(this);
		createSubjectPanel();
		createLabel();
		//trace("subject " + subject.id + " is free? " + subject.definition.isFreePoint());
		if(subject.isFree()) {
			rgb=0xff0000;
		}
	}
	
	function removeMovieClip():Void {
		subLabel.removeMovieClip();
		super.removeMovieClip();
	}
	
	function set rgb(colour:Number):Void {
		color.setRGB(colour);
	}

	function get rgb():Number {
		return color.getRGB();
	}
	
	function move(z:Complex) {
		z = _parent.complexToScreen(z);
		_x = z.x;
		_y = z.y;
		if(subject.panel._visible) {
			subject.panel.place();
		}
		//placeLabel(); 
	}
	
	function onMove():Void {
				
		var z:Complex = _parent.screenToComplex(new Complex(_x,_y));
		//trace("Redefining: " + subject.id +'='+z);
		try {
			subject.definition = new Expression(subject.id +'='+z);
			subject.panel.update();
		}
		catch(err:Error) {
			trace(err);
		}
	}

	
	function onRollOver() {
		subLabel._visible = true;
	}
	
	function onRollOut() {
		//subLabel._visible = false;
	}
	
	function onPress() {
		// start drag if free
		if(subject.isFree()) {
			this.startDrag();
			pressPoint = new Complex(_x,_y);
			onMouseMove = function() {
				onMove();
			}
		}
	}
	
	function onRelease() {
		onMouseMove = null;
		if(subject.isFree()) {
			this.stopDrag();
			if(pressPoint.minus(new Complex(_x,_y)).length < snapRadius) {
				//
				// Interpret very short drags as clicks
				//
				_x = pressPoint.x;
				_y = pressPoint.y;
				onClick();
			}
			else {
				// A non-zero drag has completed; update things
				var z:Complex = _parent.screenToComplex(new Complex(_x,_y));
				//trace("Redefining: " + subject.id +'='+z);
				try {
					subject.definition = new Expression(subject.id +'='+z);
					subject.panel.update();
				}
				catch(err:Error) {
					trace(err);
				}
			}
		}
		else {
			onClick();
		}
		//subLabel._visible = false;
		// update subject
	}
	
	function onReleaseOutside() {
		onRelease();
	}
	
	function onClick() {
		showSubjectPanel();
	}
	
	function createSubjectPanel() {
		subject.panel = SubjectPanel(_parent.createChildAtDepth("SubjectPanel", DepthManager.kTop, {subject:subject, _visible:false}));	
	}
	
	function showSubjectPanel() {
		subject.panel._visible = true;
		subLabel._visible = false;
	}
	
	function hideSubjectPanel() {
		subject.panel._visible = false;
		subLabel._visible = true;
	}
	
	function createLabel():Void {
		subLabel = attachMovie("SubLabel", "subLabel", 1, {_visible:true});
		subLabel.text = subject.id;
		placeLabel();
	}
	
	function placeLabel():Void {
		subLabel._x = 5, 
		subLabel._y = -15;
	}
}