﻿import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextInput;
import mx.controls.Button;
import Subject;
import SubjectView;
class SubjectPanel extends UIComponent {
	var subject:Subject;
	var base:MovieClip;
	var id:Label;
	var defbox:TextInput;
	var valbox:Label;
	var picker:Object;
	var okButton:Button;
	var SW:Number = 550;
	var SH:Number = 400;
	
	function draw() {
		base = this["base"];
		id = this["id"];
		defbox = this["defbox"];
		valbox = this["valbox"];
		okButton = this["okButton"]
		picker = this["picker"];
		picker.color = subject.view.rgb;
		
		// fill in values:
		id.text = subject.id;
		defbox.text = subject.definition.expr0.displayString(0);
		valbox.text = subject.evaluated.displayString();
		
		// button actions
		okButton.onRelease = function() {
			_parent.subject.view.hideSubjectPanel();
			_parent.defboxChanged();
		}
		
		// drag actions
		base.onPress = function() {
			_parent.startDrag();
		}
		
		base.onRelease = function() {
			_parent.stopDrag();
		}
		
		base.onReleaseOutside = function() {
			_parent.stopDrag();
		}
		
		// place on screen sensibly
		place();
	}
	
	function defboxChanged() {
		var e:Expression = new Expression(subject.id + "=" + defbox.text);
		subject.definition = e;
		subject.view.move(subject.evaluated);
		update();
	}

	function update():Void {
		id.text = subject.id;
		defbox.text = subject.definition.expr0.displayString(0);
		place();
	}
	
	function place():Void {
		// place on screen sensibly
		var v:SubjectView = subject.view;
		valbox.text = subject.evaluated.displayString();
		if(v._x+base._width + 10 < SW) {
			_x = v._x + 10;
		}
		else {
			_x = v._x - 5 - base._width;
		}
		_y = v._y;
		
		// Make sure we are still on screen
		_x = Math.max(0,_x);
		_y = Math.max(0,_y);
		_x = Math.min(SW-base._width,_x);
		_y = Math.min(SH-base._height,_y);

	}
	
	function colourChange():Void {
		//trace("New colour: " + picker.color.toString(16));
		var rgb:Number = subject.isFree() ? 0xff0000 : picker.color;
		subject.view.rgb = rgb;
		picker.color = rgb;
	}
}