﻿import mx.events.EventDispatcher;
import Expression;
import ComplexView;
import SubjectView;
//
// This class contains information about some subject that is probably represented by
// some screen graphic.  Subjects group together the data that
// will appear in a hoverPanel if the mouse hovers over the graphic.
//
// See Also: ComplexState - which collects Subjects
//
class Subject extends EventDispatcher {
	var id:String;
	private var _definition:Expression;
	private var _evaluated:Complex;
	var constraints:Array;
	var _isSet:Boolean = null;
	var _isFree:Boolean = null;
	var complexView:ComplexView;
	var view:SubjectView;
	var panel:SubjectPanel;
	var lineNumber:Number;
	
	function Subject(id:String, defn:Expression, complexView:ComplexView, lnum:Number) {
		this.id = id;
		constraints = [];
		_definition = defn;
		this.complexView = complexView;
		lineNumber = lnum;

		_evaluated = defn.evaluate();
		trace("Subject:30: defn = " + defn + " defn.display = " + defn.displayString());
		//trace("Subject:31: defn.display = " + defn.displayString());
		trace("Subject:32: _evaluated = " + _evaluated.displayString());
		if(_evaluated.isSet()) {
			trace("Subject:33: Create new set " + id);
			// Note that the initial definition preserves list order which 
			// will be important if we draw the set as a filled polygon.
			//
			// But for now, draw it as a set of points of the same colour
		}
		else {
			//trace("Subject:36: Plot new point at " + _evaluated.displayString());
			complexView.createSubjectView(this)
		}
	}
	
	function set definition(e:Expression):Void {
		//trace("redefine: " + e); 
		_definition = e;
		_evaluated = e.evaluate();
		_isSet = _evaluated.isSet();
		_isFree = e.isFreePoint();
		var evt:Object = {type:"revalue", target:this};
		dispatchEvent(evt);
	}
	
	function get definition():Expression {
		return _definition;
	}
	
	function isFree():Boolean {
		if(_isFree == null) {
			_isFree = _definition.isFreePoint();
		}
		return _isFree;
	}
	
	function revalue(evt:Object):Void {
		//trace("revalue " + id);
		_evaluated = _definition.evaluate();
		updateView();
		var evt:Object = {type:"revalue", target:this};
		dispatchEvent(evt);
	}
	
	function get evaluated():Complex {
		return _evaluated;
	}
	
	function get text():String {
		var txt:String = "";
		txt += (definition.displayString(0) + '\r');
		for(var c=0; c < constraints.length; c++) {
			var e:Expression=Expression(constraints[c]);
			txt += (e.displayString(0) + '\r');
		}
		return txt;
	}
	
	function isSet():Boolean {
		if(_isSet == null && evaluated != null) {
			_isSet = evaluated.isSet();
		}
		return _isSet;
	}
	
	function remove():Void {
		if(view != null) {
			//trace("Removing view on "+id);
			view.removeMovieClip();
			view = null;
		}
		if(panel != null) {
			//trace("Removing panel on "+id);
			panel.removeMovieClip();
			panel = null;
		}
	}

	// reflect Subject update in view
	function update(e:Expression, lnum):Void {
		//trace("update event on " + evt.target.id);
		if(e.isDefinition()) {
			lineNumber = lnum;
			complexView.statusMessage(id + " has been redefined",5000);
			
			// this is a redefinition; we have to replace the old one
			var newv:Complex = e.evaluate();
			if(_evaluated.isSet() == newv.isSet()) {
				// new is same type of thing as old: just move it
				definition = e;
				updateView();
			}
			else {
				remove();
				complexView.createSubjectView(this);
			}
			return;
		}
		// TODO: add some sort of constraint resolver here
		if(e.isCommand()) {
			updateInfo(e, lnum);
		}
	}
	
	function updateView():Void {
		//trace("update SubjectView on " + id);
		if(!_isSet) {
			// move view
			view.move(_evaluated);
		}
	}
	
	// update or add information on the subject
	function updateInfo(e:Expression, lnum:Number):Void {
		for(var i = 0; i < constraints.length; i++) {
			var c:Object = constraints[i];
			if(c.expression == e || c.expression.name == e.name) {
				c.lineNumber = lnum;
				c.expression = e;
				updateView();
				return;
			}
		}
		constraints.push({expression:e, lineNumber:lnum});
		updateView();
	}
	/*
	function get draggable():Boolean {
		// true if subject is a free point
		return definition.isFreePoint();
	}
	*/
	
	function toString():String {
		var s:String = id + ": def=" + definition + " val=" + evaluated;
		return s;
	}
}