﻿import Complex;
import PrimitiveSet;
class SetValue {
	private var members:Object;
	private var ordering:Array;
	
	
	function SetValue(members:Object) {
		this.members = (members == null) ? {} : members;
		
		// put any initial members in alphabetical order
		ordering = [];
		for(var m:String in members) {
			ordering.push(m);
		}
		ordering.sort();
	}
	
	function isPrimitive():Boolean {
		return false;
	}
	
	function isExpression():Boolean {
		return false;
	}
	
	function isList():Boolean {
		return true;
	}
	
	function isEmpty():Boolean {
		return members == null || members == {};
	}
	
	function contains(z:Complex):Boolean {
		return members[z.toString()] != null;
	}
		
	function intersect(s:SetValue):SetValue {
		if(this.isPrimitive()) {
			PrimitiveSet(this).intersect(s);
		}
		if(s.isPrimitive()) {
			return PrimitiveSet(s).intersectList(this);
		}
		var sv:SetValue = new SetValue();
		for(var m:String in members) {
			if(s.members[m] != null) {
				sv.members[m] = members[m];
				sv.ordering.push(m);
			}
		}
		//trace(""+this+".intersect(" + s + ") = " + sv);
		return sv;
	}
	
	function union(s:SetValue):SetValue {
		var sv:SetValue = clone();
		for(var m:String in s.members) {
			//var foo:SetValue = sv.clone();
			sv.members[m] = s.members[m];
			sv.ordering.push(m);
			//trace(""+foo + " U " + s + " = " + sv); 
		}
		return sv;
	}

	function addMember(z:Complex):SetValue {
		var m:String = z.toString();
		if(members[m] == null) {
			members[m] = z;
			ordering.push(z);
		}
		return this;
	}
	
	
	function clone():SetValue {
		var sv:SetValue = new SetValue();
		for(var i=0; i < ordering.length; i++) {
			var m = ordering[i];
			sv.members[m] = members[m];
			sv.ordering.push(m);
		}
		return sv;
	}
	
	function get length():Number {
		return ordering.length;
	}
	
	function getItem(index:Number):Complex {
		return members[ordering[index]];
	}
	
	function toString():String {
		var s:String = "";
		var sep = "";
		for(var i=0; i < ordering.length; i++) {
			s += (sep + ordering[i]);
			sep = ", ";
		}
		//trace("SetValue.toString = {" + s + "}");
		return "("+s+")";
	}
}