﻿import Complex;
import SetValue;
class RealInterval extends PrimitiveSet {
	
	public var id:String="RR";
	public var coverRatios:Array;
	
	private var generatorInterval:Array;
	private var generatorMap:Function;

	function RealInterval(id:String, range:Array, ratios:Array) {
		this.id = id;
		switch(id) {
			case "RR": {
				generatorInterval = [-Math.PI/2,Math.PI/2];
				generatorMap = Math.tan;
				coverRatios = [0.975,0.975];
				break;
			}
			case "RAY": {
				generatorInterval = [0,Math.PI/2];
				generatorMap = Math.tan;
				coverRatios = [1,0.975];
				break;
			}
			case "UI": {
				generatorInterval = [0,1];
				generatorMap = null;
				coverRatios = [1,1];
				break;
			}
			case "RANGE":
				coverRatios = [1,1];
				generatorMap = null;
				break;
			default: {
				trace("Real Interval: " + id + " not implemented as primitive");
			}
		}
		if(range != null) {
			id = "RANGE";
			generatorInterval = range.concat();
			if(ratios == null) {
				coverRatios = [1,1];
			}
			else {
				coverRatios = ratios.concat();
			}
		}
	}
	
	public function get interval():Array {
		return [generatorInterval[0]*coverRatios[0], generatorInterval[1]*coverRatios[1]];
	}
	
	public function get map():Function {
		return generatorMap;
	}
	
	function isReal():Boolean {
		return true;
	}
	
	function isPrimitive():Boolean {
		// the set is defined as a primitive set (like the reals)
		return true;
	}
	
	function isExpression():Boolean {
		return false;
	}
	
	function isList():Boolean {
		return false;
	}
	
	function isEmpty():Boolean {
		return false;
	}
	
	public function contains(z:Complex):Boolean {
		var t;
		if(z.valueOf() == Number(z).valueOf()) {
			t = z.valueOf();
		}
		else {
			if(Math.abs(z.y) > 1e-14) {
				return false;
			}
			t = z.x;
		}
		return (t >= generatorInterval[0]) && (t <= generatorInterval[1]); 
	}
	
	function clone():RealInterval {
		return id=="RANGE" ? new RealInterval(id, generatorInterval, coverRatios) : new RealInterval(id);
	}
	
	/*
	function intersectList(s:SetValue):SetValue {
		var sv = new SetValue();
		for(var m:String in s.members) {
			var el:Complex = Complex(members[m]);
			if(contains(el)) {
				sv.addMember(el);
			}
		}
		return sv;
	}
	
	function intersect(s:SetValue):PrimitiveSet {
		if(s.isPrimitive()) {
		}
		trace("TODO: PrimitiveSet intersect not implemented");
		return null;
	}
	*/
	function toString():String {
		return id=="RANGE" ? ("["+generatorInterval[0]+","+generatorInterval[1]+"]") : id;
	}
}