﻿import Complex;
import ComplexPlane;

class PolarGrid extends MovieClip {
	
	var radius:Number = 5;
	var minorRadials:Number = 24;
	var middleRadials:Number = 8;
	var majorRadials:Number = 2;
	var alpha:Number = 100;
	
	// styles
	var mini:Object = {thickness:1, rgb:0xDDDDDD, alpha:100};
	var midi:Object = {thickness:2, rgb:0xCCCCCC, alpha:100};
	var maxi:Object = {thickness:3, rgb:0xBBBBBB, alpha:100};
	
	function PolarGrid() {
	}
	
	function draw():Void {
		// Draw radials
		drawRadials(minorRadials, mini);
		drawRadials(middleRadials, midi);
		drawRadials(majorRadials, maxi);
		// Draw tangentials
		//trace("radius = " + radius);
		drawTangentials(1, 10, 5)
	}
	
	function drawRadials(radialCount:Number, style:Object):Void {
		// Draw radials
		lineStyle(style.thickness, style.rgb, style.alpha);
		//trace("style="+style.thickness+":"+style.rgb+":"+style.alpha);
		var interval:Number = Math.PI/radialCount;
		for(var i = 0; i < radialCount; i++) {
			var a:Number = i*interval;
			var rc:Number = radius*Math.cos(a);
			var rs:Number = radius*Math.sin(a);
			moveTo(-rc, -rs);
			lineTo(rc, rs);
		}
	}
	
	function drawTangentials(interval:Number, majors:Number, middles:Number):Void {
		var intervals:Number = radius/interval;
		if(intervals > 50 || isNaN(intervals)) {
			trace("bad call to Tangentials: interval="+interval+" radius="+radius);
			return;
		}
		for(var i:Number = 1; i < intervals; i++) {
			var r:Number = interval*i;
			//trace("r="+r+" interval="+interval+" i="+i);
			var style = (i%majors==0) ? maxi : ((i%middles) == 0 ? midi : mini);
			drawCircle(r, style);
		}
	}
	
	function drawCircle(r:Number, style:Object):Void {
		//trace("drawCircle(r="+r+", inc="+2*Math.PI*r/5+")");
		lineStyle(style.thickness, style.rgb, style.alpha);
		moveTo(r,0);
		var a:Number = Math.PI/4;
		var br:Number = r/Math.cos(Math.PI/8);
		var tr:Number = a/2;
		for(var t=a; t <= Math.PI*2; t += a, tr+=a) {
			curveTo(br*Math.cos(tr), br*Math.sin(tr), r*Math.cos(t), r*Math.sin(t));
		}
	}
	
	function moveTo(x:Number, y:Number):Void {
		var g:Complex = _parent.complexToScreen(new Complex(x,y));
		//trace("moveTo("+g.x+","+g.y+")");
		super.moveTo(g.x, g.y);
	}

	function lineTo(x:Number, y:Number):Void {
		var g:Complex = _parent.complexToScreen(new Complex(x,y));
		//trace("lineTo("+g.x+","+g.y+")");
		super.lineTo(g.x, g.y);
	}
	
	function curveTo(cx:Number, cy:Number, x:Number, y:Number):Void {
		var c:Complex = _parent.complexToScreen(new Complex(cx,cy));
		var g:Complex = _parent.complexToScreen(new Complex(x,y));
		super.curveTo(c.x, c.y, g.x, g.y);
	}
}