﻿import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.ColorTransform;

class PathBuffer extends MovieClip {
	var bitMap:BitmapData;
	var _w:Number;
	var _h:Number;
	
	function PathBuffer() {
		/*
		bitMap = new BitmapData(_width, _height, true, 0x00FFCCCC);
		trace("bitMap="+bitMap+" w="+_width+" h="+_height);
		attachBitmap(bitMap, 1);
		lineStyle(3,0,100);
		*/
	}
	
	function init(w:Number, h:Number) {
		_visible = true;
		_w = w;
		_h = h;
		if(bitMap != null) delete bitMap;
		bitMap = new BitmapData(w, h, true, 0x00FFCCCC);
		//trace("bitMap="+bitMap+" w="+_width+" h="+_height);
		attachBitmap(bitMap, 1, "never", true);
		lineStyle(1,0x888888,50,false);
	}
	
	function lineTo(x:Number, y:Number) {
		super.lineTo(x,y);
		//_quality="BEST";
		bitMap.draw(this);//, new Matrix(), new ColorTransform(), "normal");
	}
	
	function clear():Void {
		super.clear();
		init(_w,_h);
		//bitMap.draw(this);
		//lineStyle(1,0x888888,50,false);
	}
	
	function drawnOn(x:Number, y:Number):Boolean {
		var argb:Number = bitMap.getPixel(x,y);
		//trace("argb = "+ argb.toString(16));
		return argb != 0; 
	}
	
	function lineDrawn(x0:Number, y0:Number, x1:Number, y1:Number):Boolean {
		if(bitMap.getPixel(x0,y0) == 0) return false;
		if(bitMap.getPixel(x1,y1) == 0) return false;
		if(bitMap.getPixel((x0+x1)/2,(y0+y1)/2) == 0) return false;
		return true;
	}

	static var golden = (Math.sqrt(5)+1)/2;
	static var golden1 = (Math.sqrt(5)+1)/2+1;
	function goldenLineDrawn(x0:Number, y0:Number, x1:Number, y1:Number):Boolean {
		//if(bitMap.getPixel(x0,y0) == 0) return false;
		//if(bitMap.getPixel(x1,y1) == 0) return false;
//		if(bitMap.getPixel((x0+x1)/2,(y0+y1)/2) == 0) return false;
		if(bitMap.getPixel((x0*golden+x1)/golden1,(y0*golden+y1)/golden1) == 0) return false;
		if(bitMap.getPixel((x1*golden+x0)/golden1,(y1*golden+y0)/golden1) == 0) return false;
		return true;
	}
}