﻿import mx.core.UIComponent;
import mx.utils.Delegate;
import mx.controls.TextArea;
import mx.controls.Button;
import ComplexView;
import Expression;
class Console extends UIComponent {
	var codeArea:TextArea;
	var runButton:Button;
	var refreshButton:Button;
	var view:ComplexView;
	var state:ComplexState;
	
	function draw() {
		_alpha = 20;
		if(state == null) {
			state = new ComplexState(view);
			//Expression.state = state;
		}
		
		codeArea = this["codeArea"];
		runButton = this["runButton"];
		refreshButton = this["refreshButton"];
		
		// set initial control status
		runButton.enabled = false;
		refreshButton._visible = true;
		
		// initialise TextArea handlers
		codeArea.addEventListener("focusIn", this);
		codeArea.addEventListener("change", this);
		
		// initialise Button handlers
		runButton.addEventListener("click", this);
		refreshButton.addEventListener("click", this);
		
		// initialise View handlers
		//state.addEventListener("create", Delegate.create(view, view.create));
		//state.addEventListener("create", this);
		//state.addEventListener("update", Delegate.create(view, view.update));
		//state.addEventListener("update", this);
	}
	
	function focusIn(evt:Object):Void {
		switch(evt.target) {
			case codeArea:
				refresh();
				break;
		}
	}
	/*
	 * TODO: Use these to implement addPointToSet by clicking in z={} and then in ComplexView
	 *
	function focusOut(evt:Object):Void {
		switch(evt.target) {
			case codeArea:
				trace("code length = " + codeArea.length);
				break;
			case statusArea:
				trace("status length = " + codeArea.length);
				break;
		}
	}
	function onMouseUp():Void {
		var count = Selection.getEndIndex()-Selection.getBeginIndex();
		var s:String = codeArea.text.substr(Selection.getBeginIndex(), count);
		trace("selection = " + s + " count = " + count);
	}
	*/
	function change(evt:Object):Void {
		switch(evt.target) {
			case codeArea:
				if(codeArea.text != "") {
					runButton.enabled = true;
				}
				break;
		}
	}
	function click(evt:Object):Void {
		switch(evt.target) {
			case runButton:
				//trace("run");
				run();
				break;
			case refreshButton:
				//trace("refresh");
				refresh();
				break;
		}
	}
	//
	// run a Plex script entered in the codeArea
	//
	function run():Void {
		var lines:Array = codeArea.text.split("\r");
		//trace("lineCount = "+lines.length);
		state.reset();
		for(var lnum=0; lnum < lines.length; lnum++) {
			//trace("line: " + lnum + " = " + lines[lnum]);
			var s:String = lTrim(lines[lnum]);
			if(s != "") {
				try {
					var e:Expression = new Expression(s);			
					state.addStatement(e, lnum);
				}
				catch(err:Error) {
					trace("Error:" + lnum + " " + err);
					view.statusMessage(err.toString());
				}
			}
		}
		try {
			// calculate how variables depend on each other and set up
			// event chaining so free variables update derivative variables.
			state.chainDependencies();
		}
		catch(err:Error) {
			view.statusMessage(err.toString());
		}
		//state.setColours();
	}
	
	function refresh():Void {
		codeArea.text = state.text;
	}
	
	function lTrim(s:String):String {
		var c:String = s.charAt(0);
		for(var i=0; i < s.length; i++) {
			var c:String = s.charAt(i);
			if(c != ' ' && c != '\r' && c != '\t') {
				break;
			}
		}
		return (i==s.length) ? "" : s.substr(i);
	}
	
	//
	// Tests
	//
	function typeIn(s:String):Void {
		codeArea.text += s+"\r";
	}
	function test():Void {
		trace("hello");
		typeIn("paramList(t)");
		run();
	}
}