﻿import Subject;
import Complex;
import PathBuffer;
interface ComplexView  {
	//
	// This interface defines some geometric view of Complex numbers 
	//
	//function clear():Void;
	
	//Reset the any global view properties on ComplexState reset
	//Called before (re)reading the Plex script
	function reset():Void;
	
	// If all C is included in the view, then return true.
	// i.e. True for spherical view unless back surface is hidden completely.
	//      False for planar view because window will clip the plane.
	function allPointsVisible():Boolean;
	
	// True if screen coords are on screen
	function onScreen(screen:Complex):Boolean;
	
	// True if an z is visible on screen
	function reallyVisible(z:Complex):Boolean;
	
	// Translate complex z to screen coordinates
	function complexToScreen(z:Complex):Complex;

	// Translate screen coordinates to complex z
	function screenToComplex(z:Complex):Complex;
	
	// create a movieclip to represent the subject in the view
	function createSubjectView(subject:Subject):Void
	
	// return a pathBuffer which we can use for offScreen drawing
	function getPathBuffer():PathBuffer;
	
	// display a status message for interval milliseconds
	function statusMessage(msg:String, interval:Number):Void;
	
	// clear the status message
	function clearMessage():Void;

	//
	function createEmptyMovieClip(name:String, depth:Number):MovieClip;
}