﻿import mx.events.EventDispatcher;
import mx.utils.Delegate;
import ComplexView;
import Expression;
import Subject;
//
// This class is responsible for storing the state represented by the statements typed in
// together with any state changes caused by user interaction with the different geometrical 
// views and hoverPanels.
//
//
// It's the Model of a Model/View/Controller triplet where View is a ComplexView 
// and Controller is the Console class. It communicates updates to its views using events.
//
// Statements are about Subjects. e.g. z=1 and z>0 are both statements about z. This class
// creates and maintains the subject list.
//
class ComplexState extends EventDispatcher {
	var variables:Object = {};
	var subjects:Array;
	var view:ComplexView;
	
	function ComplexState(view:ComplexView) {
		subjects = [];
		variables = {};
		this.view = view;
	}
	
	function reset():Void {
		var s:Subject;
		while((s=Subject(subjects.pop())) != null) {
		//for(var id:String in subjects) {
			s.remove();
		}
		variables = {};
		//subjects = {};
		view.reset();
	}
	
	function addSubject(id:String, e:Expression, lnum:Number):Subject {
		trace("addSubject "+id);
		var s:Subject = new Subject(id, e, view, lnum);
		variables[id]=s;
		subjects.push(s);
		return s;
	}
	
	function addStatement(e:Expression, lnum:Number):Void {
		var id:String = getSubjectId(e);
		if(id == null) {
			// statement has no subject: evaluate immediately
			if(e.isCommand()) {
				trace("Command");
			}
			trace("ComplexState:55 subjectId = "+id);
			return;
		}
		var s:Subject = getSubject(id);
		//var evt:Object = {};
		if(s==null) {
			s = addSubject(id, e, lnum);

		}
		else {
			s.update(e, lnum);
		}
	}

	// return a Plex script that would regenerate the current state
	function get text():String {
		var txt:String = "";
		var sortedSubjects:Array = subjects.concat();
		sortedSubjects.sortOn("lineNumber");
		for(var i:Number = 0; i < sortedSubjects.length; i++) {
			var s:Subject = Subject(sortedSubjects[i]);
			if(s.lineNumber < 0) {
				continue;
			}
			//var s:Subject = getSubject(id);
			txt += s.text;
		}
		return txt;
	}
	
	/*
	function removeDependencies():Void {
		for(var id:String in subjects) {
			var s:Subject = getSubject(id);
			
			s.removeEventListener("revalue"; 
		}
	}
	*/
	
	function chainDependencies():Void {
		// TODO: Detect dependency loops and throw error if found
		// TODO: Make sure event listeners are removed on reset
		for(var i:Number = 0; i < subjects.length; i++) {
			var s:Subject = Subject(subjects[i]);
			s.definition.callDependencies(this, addLink, s); 
		}
	}
	
	function addLink(s:Subject, variable:Expression):Void {
		trace(s.definition.name + "->" + variable.name);
		if(s.definition.name == variable.name) {
			throw new Error("Recursive definition of " + variable.name);
		}
		var dependency:Subject = getSubject(variable.name); //subjects[variable.name];
		if(dependency != null) {
			dependency.addEventListener("revalue", Delegate.create(s, s.revalue));
		}
	}
	
	/*
	function setColours():Void {
		for(var id:String in subjects) {
			var s:Subject = getSubject(id);
			s.view.rgb = s.definition.isFreePoint() ? 0xff0000 : 0x888888; 
		}
	}
	*/
	
	private function getSubjectId(e:Expression):String {
		return e.mainVariable().name;
	}
	
	private function getSubjectOf(e:Expression):Subject {
		return getSubject(getSubjectId(e));
	}
	
	private function getSubject(id:String):Subject {
		return Subject(variables[id]);
		/*
		for(var i:Number = 0; i < subjects.length; i++) {
			var s:Subject = Subject(subjects[i]);
			if(s.id == id) {
				return s;
			}
		}
		return null;
		*/
	}
	
}