﻿import mx.core.UIComponent;
import mx.managers.DepthManager;
import mx.controls.CheckBox;
import mx.controls.TextArea;
import Complex;
import ComplexView;
import Subject;
import SubjectView;
import SubjectPanel;
import PathBuffer;
import PolarGrid;
import CartesianGrid;

class ComplexPlane extends UIComponent implements ComplexView {
	var origin:Complex;
	var unit:Number;
	var polarCheck:CheckBox;
	var cartesianCheck:CheckBox;
	var statusArea:TextArea;
	var SW:Number = 550;
	var SH:Number = 400;
	private var lowestFreePoint:MovieClip;
	private var _bounds:Object = null;

	private var polar : MovieClip;
	private var cartesian : MovieClip;
	
	function ComplexPlane() {
		origin = new Complex(SW-SH/2, SH/2);
		unit = SH/20;
	}
	
	function bounds():Object {
		if(_bounds == null) {
			var tl:Complex = screenToComplex(new Complex(0));
			var br:Complex = screenToComplex(new Complex(SW,SH));
			_bounds = {xMin:tl.x, xMax:br.x, yMin:br.y, yMax:tl.y};
			//trace("bounds = "+_bounds.xMin+" "+_bounds.xMax+":"+_bounds.yMin+" "+_bounds.yMax);
		}
		return _bounds;
	}
	/*
	static var LEFT:Number = -20;
	static var RIGHT:Number = 550+20;
	static var TOP:Number = -20;
	static var BOTTOM:Number = 400+20;
	*/
	static var LEFT:Number = 0;
	static var RIGHT:Number = 550;
	static var TOP:Number = 0;
	static var BOTTOM:Number = 400;
	function onScreen(screen:Complex):Boolean {
		return (screen.x >= LEFT
				&& screen.x <= RIGHT
				&& screen.y >= TOP
				&& screen.y <= BOTTOM);
	}
	
	function reallyVisible(z:Complex):Boolean {
		var b:Object = bounds();
		return (z.x >= b.xMin 
				&& z.x <= b.xMax 
				&& z.y >= b.yMin 
				&& z.y <= b.yMax);
	}
	
	function allPointsVisible():Boolean {
		return false;
	}
	
	function draw():Void {
		statusArea = TextArea(createChildAtDepth("TextArea", DepthManager.kTop, {_x:150, _y:339, _width:390, _height:34, editable:"false", wordWrap:true}));
		statusArea._visible = false;
		drawPolar();
		drawCartesian();
		polarCheck = CheckBox(createChildAtDepth("CheckBox", DepthManager.kTop, {_x:450, _y:378, label:"polar", selected:false}));
		polarCheck.addEventListener("click", this);
		cartesianCheck = CheckBox(createChildAtDepth("CheckBox", DepthManager.kTop, {_x:350, _y:378, label:"cartesian", selected:false}));
		cartesianCheck.addEventListener("click", this);
	}
	
	// reset any global view properties
	function reset():Void {
		lowestFreePoint = null;
	}
	
	
	public function complexToScreen(z:Complex):Complex {
		return z.conjugate().times(unit).plus(origin);
	}

	public function screenToComplex(z:Complex):Complex {
		return z.minus(origin).over(unit).conjugate();
	}

	var messageId:Number = null;
	function statusMessage(msg:String, interval:Number):Void {
		statusArea.text = msg;
		statusArea._visible = true;
		messageId = setInterval(this, "clearMessage", interval);
	}
	
	function clearMessage():Void {
		statusArea.text = "";
		statusArea._visible = false;
		messageId = null;
	}
	
	public function createSubjectView(subject:Subject):Void {
		//trace("creating subject view on: " + subject); 
		var z:Complex = subject.evaluated;
		z = complexToScreen(z);
		//
		// TODO: distinguish the different kinds of subject here: (Point, Set ...)
		//
		subject.view = SubjectView(createChildAtDepth("Point", DepthManager.kTop, {_x:z.x, _y:z.y, subject:subject}));
		if(lowestFreePoint == null && subject.isFree()) {
			lowestFreePoint = subject.view;
			trace("lowestFreePoint = " + subject.id + " depth="+subject.view.getDepth());
		}
		if(!subject.isFree()) {
			//
			// Following typecast is necessary for the setDepthBelow add-in (weird)
			// 
			(MovieClip(subject.view)).setDepthBelow(lowestFreePoint);
			trace("setting " + subject.id + " below " + lowestFreePoint.getDepth()+ " depth="+subject.view.getDepth());
		}
	}
	
	private var _pathBuffer:PathBuffer = null;
	public function getPathBuffer():PathBuffer {
		// return a PathBuffer the same size as the View for offscreen drawing
		//trace("w="+_width+" _height="+_height+ " h="+height);
		if(_pathBuffer == null) {
			trace("New PathBuffer");
			_pathBuffer =  PathBuffer(createChildAtDepth("PathBuffer", DepthManager.kTop, {_x:0, _y:0}));
			//var pb:PathBuffer =  PathBuffer(_root.attachMovie("PathBuffer", "pathBuffer", 100, {_x:0, _y:0}));
			_pathBuffer.init(SW,SH);
		}
		//_pathBuffer.clear();
		return _pathBuffer;
	}
	
	function click(evt:Object) {
		switch(evt.target) {
			case polarCheck:
				polar._visible = polarCheck.selected;
				break;
			case cartesianCheck:
				cartesian._visible = cartesianCheck.selected;
				break;
			default:
				trace("unknown click in CartesianPlane");
		}
	}
	
	//
	// Private from here
	//
	private function drawPolar():Void {
		//trace("drawPolar");
		var radius:Number = (SW - Math.min(origin.length, SW-origin.length))/unit;
		polar = attachMovie("PolarGrid", "polar", 1, {radius:radius});
		//polar = createChildAtDepth("PolarGrid", DepthManager.kTop, {radius:radius});
		polar.draw();
		polar._visible = false; //polarCheck.selected;
		polar.cacheAsBitmap = false;
		
	}

	private function drawCartesian():Void {
		//trace("drawCartesian");
		//var radius:Number = SW - Math.min(origin.length, SW-origin.length);
		var xMax = (SW-origin.x)/unit;
		var xMin = -origin.x/unit; 
		var yMax = (SH-origin.y)/unit;
		var yMin = -origin.y/unit; 
		cartesian = attachMovie("CartesianGrid", "cartesian", 2, {xMin:xMin, xMax:xMax, yMin:yMin, yMax:yMax});
		cartesian.draw();
		cartesian._visible = false;//cartesianCheck.selected;
		cartesian.cacheAsBitmap = false;
	}

}