﻿import Toolbox;
import Plane;
import mx.controls.CheckBox;

class VisibilityToolbox extends Toolbox {
	var plane:Plane;
	var depth:Number = 3;
	var latticeCheckBox:CheckBox;
	var planeCheckBox:CheckBox;
	var gridCheckBox:CheckBox;
	var lineSeparation = 20;

	function VisibilityToolbox() {
		var x:Number = iconWidth+padding;
		var y:Number = padding;
		boxWidth = 130;
		planeCheckBox = CheckBox(createClassObject(CheckBox,"planeCheckBox",depth++,{label:"Show Transforms", selected:true}));
		planeCheckBox.move(x, y);
		planeCheckBox.setSize(boxWidth, lineSeparation);
		latticeCheckBox = CheckBox(createClassObject(CheckBox,"latticeCheckBox",depth++,{label:"Show Lattice", selected:false}));
		latticeCheckBox.move(x, y+=lineSeparation);
		latticeCheckBox.setSize(boxWidth, lineSeparation);
		gridCheckBox = CheckBox(createClassObject(CheckBox,"gridCheckBox",depth++,{label:"Show Grid", selected:false}));
		gridCheckBox.move(x, y+=lineSeparation);
		gridCheckBox.setSize(boxWidth, lineSeparation);
		boxHeight = y+lineSeparation+padding;
	}
	
	public function draw():Void {
		super.draw();
		latticeCheckBox.addEventListener("click", this);
		planeCheckBox.addEventListener("click", this);
		gridCheckBox.addEventListener("click", this);
		minimised = true;
	}
	
	public function set minimised(b:Boolean):Void {
		latticeCheckBox.visible = !b;
		planeCheckBox.visible = !b;
		gridCheckBox.visible = !b;
		super.minimised = b;
	}
	
	public function get minimised():Boolean {
		return super.minimised;
	}
	
	function click(evt:Object) {
		switch(evt.target) {
			case latticeCheckBox:
				plane.group._visible = latticeVisible;
				return;
			case planeCheckBox:
				trace ('plane clicked');
				return;
			case gridCheckBox:
				trace ('grid clicked');
				return;
		}
	}
	
	function get latticeVisible():Boolean {
		return latticeCheckBox.selected;
	}
	
	function get planeVisible():Boolean {
		return planeCheckBox.selected;
	}

	function get gridVisible():Boolean {
		return gridCheckBox.selected;
	}
	
}