﻿class Vector {
	var x:Number = 0;
	var y:Number = 0;
	private var _len:Number;
	function Vector(p:Object, q:Object) {
		if(isNaN(p)) {
			x = p.x;
			y = p.y;
		}
		else {
			x = Number(p);
			y = isNaN(Number(q)) ? 0 : q;
		}
		_len = Math.sqrt(x*x+y*y);
	}
	function get length():Number {
		return _len;
	}
	function plus(v:Vector):Vector {
		return new Vector({x:(x+v.x), y:(y+v.y)});
	}
	function minus(v:Vector):Vector {
		return new Vector({x:(x-v.x), y:(y-v.y)});
	}
	function negate():Vector {
		return new Vector({x:-x, y:-y});
	}
	function times(s:Number):Vector {
		return new Vector({x:s*x, y:s*y});
	}
	function dot(v:Vector):Number {
		return x*v.x + y*v.y;
	}
	function crozz(v:Vector):Number {
		return (v.x*y - v.y*x);
	}
	function hasValue():Boolean {
		return !(isNaN(x) || isNaN(y));
	}
	function rotate(theta:Number):Vector {
		var c:Number = Math.cos(theta);
		var s:Number = Math.sin(theta);
		var x1:Number = c*x+s*y;
		var y1:Number = -s*x+c*y;
		return new Vector({x:x1, y:y1});
	}
	function round():Vector {
		return new Vector({x:Math.round(x), y:Math.round(y)});
	}
	function floor():Vector {
		return new Vector({x:Math.floor(x), y:Math.floor(y)});
	}
	function toString():String {
		return "("+x+","+y+")";
	}
}