﻿import Vector;
import Transform;
class Translation extends Transform {
	var vector:Vector;

	function Translation() {
		draw();
	}
	
	function draw():Void {
		//trace("vector = " + vector);
		lineStyle(5,0x888888, 60);
		moveTo(0,0);
		lineTo(vector.x, vector.y);
	}

	function highlight():Void {
		//trace("vector = " + vector);
		lineStyle(7,0xFF3300, 100);
		moveTo(0,0);
		lineTo(vector.x, vector.y);
	}
	
	function idName():String {
		return "Translation";
	}
	
	function toString():String {
		return "T"+vector;
	}
	
	var tween0:Object;
	function tween(t:Number):Void {
		//trace("Translate.tween("+t+")" + " parent = "+_parent + "vector="+vector);
		// transform our vector into global space
		var v:Vector = parentVector(vector);
		var dv = v.times(t);
		if(t <= 0) {
			tween0 = {x:_parent._x, y:_parent._y};
			return;
		}
		if(t>=1) {
			_parent._x = tween0.x+v.x;
			_parent._y = tween0.y+v.y;
		}
		else {
			_parent._x = tween0.x+dv.x;
			_parent._y = tween0.y+dv.y;
		}
	}
	
	function onRollOver():Void {
		clear();
		highlight();
	}
	
	function onRollOut():Void {
		clear();
		draw();
	}
}