﻿import Toolbox;
import Plane;
import mx.controls.CheckBox;

class TransformToolbox extends Toolbox {
	var plane:Plane;
	var buttons:Array;

	function TransformToolbox() {
		boxWidth = 130;
		boxHeight = 80;
	}
	
	public function draw():Void {
		super.draw();
		buttons = [];
		buttons.push(attachMovie("R1", "r1", 12, {_x:0, _y:0, order:1}));
		buttons.push(attachMovie("R2", "r2", 13, {_x:30, _y:0, order:2}));
		buttons.push(attachMovie("R3", "r3", 14, {_x:60, _y:0, order:3}));
		buttons.push(attachMovie("R4", "r4", 15, {_x:90, _y:0, order:4}));
		buttons.push(attachMovie("R5", "r5", 16, {_x:0, _y:40, order:5}));
		buttons.push(attachMovie("R6", "r6", 17, {_x:30, _y:40, order:6}));
		buttons.push(attachMovie("R7", "r7", 18, {_x:60, _y:40, order:7}));
		buttons.push(attachMovie("R8", "r8", 19, {_x:90, _y:40, order:8}));
		for(var i = 0; i < buttons.length; i++) {
			var b = buttons[i];
			b._x += iconWidth + padding + 10;
			b._y += padding + 10;
			b.toolbox = this;
		}
		minimised = true;
		//trace("TransformTB Plane = " + plane + " grp= " + plane.group);
	}
	
	public function set minimised(b:Boolean):Void {
		for(var i = 0; i < buttons.length; i++) {
			var but:Rotation = Rotation(buttons[i]);
			but._visible = !b;
		}
		super.minimised = b;
	}
	
	public function get minimised():Boolean {
		return super.minimised;
	}
	
	function createTransform(t:Transform):Transform {
		return plane.cloneTransform(t);
	}

}