﻿import Panel;
import Plane;
import TransformToolbox;
class Transform extends MovieClip {
	public var id:String="Identity";
	//public static var snapTolerance:Number = 5;
	public var toolbox:TransformToolbox;
	
	function Transform() {
		if(_parent instanceof TransformToolbox) {
			onRollOver = function() {
				toolbox.panel.onBox.call(toolbox.panel.onOffObject);
			}
			onRollOut = function() {
				toolbox.panel.offBox.call(toolbox.panel.onOffObject);
			}
		}
	}
	
	function get matrix():Array {
		// default to a translation through (_x,_y)
		return [[1, 0, _x], [0, 1, _y], [0, 0, 1]];
	}
	
	function get centre():Vector {
		return new Vector({x:_x, y:_y});
	}
	
	function set centre(v:Vector):Void {
		_x = v.x;
		_y = v.y;
	}
	
	function cloneParameters(t:Transform):Void {
	}
	
	function parentXY():Object {
		var p:Object = {x:_x, y:_y};
		_parent.localToGlobal(p);
		return p;
	}
	
	// returns a vector in parent coordinate system
	function parentVector(v:Vector):Vector {
		var p:Object = {x:_x, y:_y};
		_parent.localToGlobal(p);
		var q:Object = {x:_x+v.x, y:_x+v.y};
		_parent.localToGlobal(q);
		return new Vector({x:q.x-p.x, y:q.y-p.y});
	}
	
	function tween(t:Number):Transform {
		trace(_name + ".tween(" + t + ") not implemented");
		return this;
	}

	function idName():String {
		return "Transform";
	}
	
	function toString():String {
		return idName();
	}
	
	function get order():Number {
		return 1;
	}
	
	function equals():Boolean {
		return false;
	}
	
	function set selected(b:Boolean):Void {
		gotoAndStop(b ? 2 : 1);
	}
	
	function get selected():Boolean {
		return _currentframe==2;
	}
	
	function onRollOver():Void {
		//trace("RollOver");
		//selected = true;
	}
	
	function onRollOut():Void {
		//selected = false;;
	}
	
	function onRelease():Void {
		if(_parent instanceof TransformToolbox) {
			var child:Transform = _parent.createTransform(this);
			var mid:Object = child._parent.getMaskBounds().mid;
			child._x = mid.x; //child._parent._x;
			child._y = mid.y; //child._parent._y;
			//child._parent.drawMaskBounds();
			//trace("child="+child);
			child.onEnterFrame = function() {
				_x = _x*0.6 + 0.4*_parent._xmouse;
				_y = _y*0.6 + 0.4*_parent._ymouse;
				//
				// test highilghting on grid points
				//
				//var rx = (_x % 60);
				//var ry = (_y % 60);
				//if((rx < 10 || rx > 50) && (ry < 10 || ry > 50)) {
				//	selected = true;
				//}
				//else {
				//	selected = false;
				//}
				selected = wouldSnap;
			}
		}
		else {
			if(onEnterFrame == null) {
				_parent.animate(this);
			}
			else {
				onEnterFrame = undefined;
				switch(_parent.insertTransform(this)) {
					case Plane.IGNORE, Plane.CONFLICT:
						this.removeMovieClip();
						break;
					case Plane.INSERT: 
						break;
					case Plane.PROMOTE:
						break;
				}
			}
		}
	}

	function get wouldSnap():Boolean {
		// virtual
		return false;
	}
}

