﻿import mx.core.UIObject;
class Toolbox extends UIObject {

	public var box:MovieClip = null;
	public var boxWidth:Number = 100;
	public var boxHeight:Number = 100;
	public var rollOverIcon:MovieClip = null;
	public var iconColour:Number = 0xCCCCCC;
	public var iconAlpha:Number = 0xCCCCCC;
	public var iconWidth:Number = 20;
	public var iconHeight:Number = 20;
	public var padding:Number = 10;
	public var bgColour:Number = 0xCCCCCC;
	public var bgAlpha:Number = 80;
	public var panel:Panel;
	
	public var _minimised:Boolean = false;
	
	function Toolbox() {
		super();
		validateNow = true;
		//onRollOver = rollOverAction;
		//doLater(this, "reset");
	}
	
	function set minimised(b:Boolean):Void {
		box._visible = !b;
		_minimised = b;
	}
	
	function get minimised():Boolean {
		return _minimised;
	}
	
	function toggleMinimised():Void {
		minimised = !minimised;
	}
	
	function draw() {
		//trace("Toolbox.draw");
		if(rollOverIcon==null) drawIcon()
		if(box==null) drawBox();
		minimised = false;
	}
	
	function drawBox():Void {
		createEmptyMovieClip("box", 1);
		box = this["box"];
		box._x = iconWidth;
		box.lineStyle(1, 0, 0);
		box.beginFill(bgColour, bgAlpha);
		box.moveTo(0, 0);
		box.lineTo(boxWidth, 0);
		box.lineTo( boxWidth, boxHeight);
		box.lineTo(0, boxHeight);
		box.lineTo(0, 0);
		box.endFill();
		box.useHandCursor = false;
		
		box.onRollOver = function() {
			//trace("onOffObject = " + _parent.panel.onOffObject);
			_parent.panel.onBox.call(_parent.panel.onOffObject);
		}
		
		box.onRollOut = function() {
			//trace("onOffObject = " + _parent.panel.onOffObject);
			_parent.panel.offBox.call(_parent.panel.onOffObject);
		}
		
		box.onRelease = function() {
			_parent.minimised = true;
		}
	}
	
	function drawIcon():Void {
		createEmptyMovieClip("rollOverIcon", 2);
		rollOverIcon = this["rollOverIcon"];
		rollOverIcon.lineStyle(1, 0, 30);
		rollOverIcon.beginFill(iconColour, iconAlpha);
		rollOverIcon.moveTo(0, 0);
		rollOverIcon.lineTo(iconWidth, 0);
		rollOverIcon.lineTo(iconWidth, iconHeight);
		rollOverIcon.lineTo(0, iconHeight);
		rollOverIcon.lineTo(0, 0);
		rollOverIcon.endFill();
		
		rollOverIcon.onRelease = function() {
			_parent.panel.minimiseAll();
			_parent.minimised = true;
		}
		
		rollOverIcon.onRollOver = function() {
			_parent.panel.minimiseAll();
			_parent.minimised = false;
		}
		
		rollOverIcon.onRollOut = function() {
			if(_parent.offIconAndToolbox()) {
				_parent.minimised = true;
			}
		}
		
	}
	
	
	function offIconAndToolbox():Boolean {
		// 
		// return true if we rolled off both the rollOverIcon and the toolbox 
		//
		//trace("_ymouse="+_ymouse);
		return _xmouse < iconWidth || _ymouse < 0 || _ymouse > iconHeight;
	}
	
}