﻿import Config;
import Plane;
import Transform;
import Vector;
import Group;
class Rotation extends Transform {
	//
	// Note: May need to refactor this code to use full precision configuration
	// parameters rather than _x, _y etc. (which are integers).
	//
	//
	public var i:Number = 0;
	public var j:Number = 0;
	private var _order:Number = 2;
	private var _angle:Number = 360/_order;
	
	function Rotation() {
	}
	
	function get matrix():Array {
		// return matrix for a rotation about (_x,_y) through _angle
		var theta = radians();
		var c = Math.cos(theta);
		var s = Math.sin(theta);
		return [
				[c, s, (c-1)*_x + s*_y],
				[-s, c, -s*_x +(c-1)*_y],
				[0, 0, 1]
				];
	}
	
	function cloneParameters(r:Rotation):Void {
		order = r.order;
		super.cloneParameters();
	}
	
	function get id():String {
		// The id should identify this transform uniquely, whatever plane it is in.
		// Note that the transform id can change if the parent plane transforms.
		var p:Vector = new Vector(0,0);
		localToGlobal(p);
		return "R"+order+p.round();
	}
	
	function toString():String {
		return id();
	}
	
	function idName():String {
		return "R"+order;
	}
	
	function equals(t:Transform):Boolean {
		var p:Vector = new Vector({x:0, y:0});
		var q:Vector = new Vector({x:0, y:0});
		localToGlobal(p);
		t.localToGlobal(q);
		if ((t instanceof(Rotation)) 
			&& (p.minus(q).length < Config.snapTolerance)) {
			if (_order==t.order) {
				return true;
			}
			else {
				// transforms conflict
				return null;
			}
		}
		else {
			return false;
		}
	}
	
	function promote(newOrder:Number) {
	}
	
	function set order(n:Number):Void {
		if (n <= 0 || isNaN(n)) {
			n = 1;
		}
		_angle = Math.floor(360/n);
		_order = Math.floor(360/_angle);
		//trace("order = " + _order);
	}
	
	function get order():Number {
		return _order;
	}
	
	function set degrees(d:Number):Void {
		if(d == 0 || !isNaN(d)) {
			d = 360;
		}
		order = 360/d;
	}
	
	function get degrees():Number {
		return _angle;
	}
	
	function get radians():Number {
		return _angle*Math.PI/180;
	}
	
	//var tweenRot:Number = 0;
	var tween0:Object;
	function tween(t:Number):Void {
		//trace("Rotate.tween("+t+")" + " parent = "+_parent + "_angle="+_angle);
		var g1:Object;
		if(t <= 0) {
			tween0 = {g1:parentXY(), rot:_parent._rotation, x:_parent._x, y:_parent._y};
			return;
		}
		if(t>=1) {
			g1 = tween0.g1;
			_parent._x = tween0.x;
			_parent._y = tween0.y;
		}
		else {
			g1 = parentXY();
		}
		_parent._rotation = tween0.rot + _angle*t;
		//
		//
		//_rotation -= _angle*t;
		//
		//
		var g2:Object = parentXY();
		_parent._x += (g1.x-g2.x);
		_parent._y += (g1.y-g2.y);
	}

	function get wouldSnap():Boolean {
		// Return true if this rotation would snap into the parent plane's group 
		return _parent.rotationWouldSnap(this);
	}
	

}
