﻿import MaskPane;
import Transform;
import Group;
class Plane extends MovieClip {

	var mask:MaskPane;
	var maskBounds:Object;
	var transforms:Array;
	var group:Group;
	
	// Animated Transform variables
	public static var tweens = 20;
	private var _dup:Plane;
	private var _tween:Transform;
	private var _tweenFrame = 0;
	
	function Plane() {
		transforms = [];
		//trace("mask = " + mask);
		//setMask(mask);
		//mask._alpha=0;
		mask._visible = false;
		//drawMaskBounds();
		//trace("plane is at: "+_x + " " + _y);
	}
	
	public function clear():Void {
		for(var i = 0; i < transforms.length; i++) {
			var t:Transform = Transform(transforms[i]);
			t.removeMovieClip();
		}
		super.clear();
	}
	
	public function getMaskBounds():Object {
		var tl:Object = {x:0, y:0};
		var tr:Object = {x:mask._width, y:0};
		var bl:Object = {x:0, y:mask._height};
		var br:Object = {x:mask._width, y:mask._height};
		mask.localToGlobal(tl);
		mask.localToGlobal(tr);
		mask.localToGlobal(bl);
		mask.localToGlobal(br);
		globalToLocal(tl);
		globalToLocal(tr);
		globalToLocal(bl);
		globalToLocal(br);
		var mid:Object = {x:(tl.x+tr.x+bl.x+br.x)/4, y:(tl.y+tr.y+bl.y+br.y)/4};
		return {tl:tl, tr:tr, bl:bl, br:br, mid:mid};
	}
	
	public function drawMaskBounds():Void {
		maskBounds = getMaskBounds();
		lineStyle(1,0,100);
		super.moveTo(maskBounds.tl.x, maskBounds.tl.y);
		super.lineTo(maskBounds.tr.x, maskBounds.tr.y);
		super.lineTo(maskBounds.br.x, maskBounds.br.y);
		super.lineTo(maskBounds.bl.x, maskBounds.bl.y);
		super.lineTo(maskBounds.tl.x, maskBounds.tl.y);
	}
	//
	// duplicate the plane in its current configuration 
	//
	public function duplicate():Plane {
		var dup:Plane = Plane(_parent.attachMovie("Plane", "plane2", 2, {mask:mask, _x:_x, _y:_y, _rotation:_rotation, _xscale:_xscale, _yscale:_yscale, _alpha:_alpha}));
		for(var i:Number = 0; i < transforms.length; i++) {
			var t : Transform = Transform(transforms[i]);
			dup.transforms.push(dup.cloneTransform(t));
		}
		return dup;
	}
	
	public function cloneTransform(t:Transform):Transform {
		var d = getNextHighestDepth();
		if(_name == "plane") {
			trace("new plane at depth:" + d);
		}
		var clone:Transform = Transform(attachMovie(t.idName(), t.idName()+d, d, {_x:t._x, _y:t._y, _rotation:t._rotation, _xscale:t._xscale, _yscale:t._yscale}));
		clone.cloneParameters(t);
		return clone;
	}
	
	public function cloneTransformAtPoint(t:Transform, point:Object):Transform {
		var clone = cloneTransform(t);
		globalToLocal(point);
		clone._x = point.x;
		clone._y = point.y;
		//
		// Uncomment following line if you want to minimise rotation snapping
		// and allow transforms to appear at more than one orientation
		//
		//clone._rotation = -_rotation;
		return clone;
	}
	
	static var INSERT:Number = 0;
	static var CONFLICT:Number = 1;
	static var IGNORE:Number = 2;
	static var PROMOTE:Number = 3;

	public function insertTransform(t:Transform):Number {
		group.insertTransform(t);
		trace("Group: "+ group + " name: " + group.toString());
		//
		// a true return indicates a conflicting transform
		//
		var id:String = t.id;
		for(var i:Number = 0; i < transforms.length; i++) {
			var ti:Transform = Transform(transforms[i]);
			var equal:Boolean = t.equals(ti);
			if(equal) {
				// it already exists
				trace("transform "+t+" already present");
				t.removeMovieClip();
				return IGNORE;
			}
			else if(equal == null) {
				trace("conflict between " + t + " and " + ti);
				return CONFLICT;
			}
		}
		trace("inserting Transform "+t);
		trace("latticeEquivalent is " + group.latticeEquivalent(t));
		transforms.push(t);
		return INSERT;
	}
	
	//function getLatticeTransform(t:Transform):Transform {
	//	return group.mapToQuotient(t);
	//}
		
	
	// merges a plane with this one
	function merge(plane:Plane):Void {
		trace("merge: plane.transforms.length = " + plane.transforms.length);
		for(var i:Number=0; i < plane.transforms.length; i++) {
			var t:Transform = Transform(plane.transforms[i]);
			//trace("plane.transform = " + t);
			var p:Object = {x:t._x, y:t._y};
			plane.localToGlobal(p);
			var clone:Transform = cloneTransformAtPoint(t, p);
			var returnValue:Number = insertTransform(clone);
			//trace("insertTransform("+clone+") = " + returnValue);
			switch(returnValue) {
				case CONFLICT:
					// highlight conflict somehow
					trace("Conflict: " + clone);
					break;
				case INSERT:
					trace("INSERT" + t);
					clone._rotation += (plane._rotation - _rotation);
					//clone._rotation = plane._rotation + t._rotation-clone._parent._rotation;
					break;
				case IGNORE:
					trace("IGNORE " + t);
					clone.removeMovieClip();
					break;
				case PROMOTE:
					trace("PROMOTE " + t);
					clone._rotation += (plane._rotation - _rotation);
					//clone._rotation = plane._rotation + t._rotation-clone._parent._rotation;
					break;
				}
			t.removeMovieClip();
		}
		plane.removeMovieClip();
	}
	
	public var animating:Boolean = false;
	
	function animate(t:Transform):Void {
		if(!animating) {
			_dup = duplicate();
			_tween = t;
			_tweenFrame = 0;
			onEnterFrame = showTween;
			animating = true;
		}
	}
	
	static var easePoints:Array = [0,0.0006,0.0056,0.0162,0.0346,0.0641,0.1075,0.1674,0.2518,0.3621,0.5,0.6308,0.7388,0.8249,0.8897,0.9369,0.9669,0.9855,0.9961,1.000];
	function showTween():Void {
		if(_tweenFrame < tweens) {
			//trace("plane._rotation = "+_rotation);
			_tween.tween(easePoints[_tweenFrame++]);
		}
		else {
			onEnterFrame = undefined;
			animating = false;
			merge(_dup);
		}
	}
	/*
	function onPress() {
		this.startDrag();
	}
	
	function onRelease() {
		stopDrag();
	}
	*/
	function rotationWouldSnap(rotation:Rotation):Boolean {
		return (group.compatible(rotation) != null);
	}
}