﻿import Plane;
import TransformToolbox;
import CursorToolbox;
import VisibilityToolbox;
//import mx.controls.CheckBox;

class Panel extends MovieClip {
	var plane:Plane;
	var transformToolbox:TransformToolbox;
	var cursorToolbox:CursorToolbox;
	var visibilityToolbox:VisibilityToolbox;
	var toolboxes:Array;
	var padding:Number = 10;
	var separation:Number = 20;
	var colours = [0xFF8888, 0xDDDD88, 0x88FF88, 0x88DDDD, 0x8888FF, 0xDD88DD];
	public var onBox:Function;
	public var offBox:Function;
	public var onOffObject:Object;

	
	function Panel() {
		var d:Number = 0;
		transformToolbox = TransformToolbox(attachMovie("TransformToolbox", "transformToolbox", d++, {plane:plane}));
		visibilityToolbox = VisibilityToolbox(attachMovie("VisibilityToolbox", "visibilityToolbox", d++, {plane:plane}));
		cursorToolbox = CursorToolbox(attachMovie("CursorToolbox", "cursorToolbox", d++, {plane:plane}));
		toolboxes = [transformToolbox,
					 visibilityToolbox,
					 cursorToolbox];
		for(var i:Number = 0; i < toolboxes.length; i++) {
			var tb:Toolbox = Toolbox(toolboxes[i]);
			tb._x = padding;
			tb._y = padding + i*separation;
			tb._alpha = 100;
			//tb.bgColour = colours[i];
			tb.iconColour = colours[i];
			tb.panel = this;
		}
	}

	function minimiseAll():Void {
		for(var i:Number = 0; i < toolboxes.length; i++) {
			var tb = toolboxes[i];
			tb.minimised = true;
		}
	}
	
	function get latticeVisible():Boolean {
		return visibilityToolbox.latticeVisible;
	}
}