﻿import Config;
import Vector;
import Transform;
import Rotation;
import Translation;
import Reflection;
import Glide;
import Matrix;
import Grid;
class Group extends Plane {
	//
	// This class captures what we know about the symmetry group given the transforms 
	// it contains so far. It's main functions are 
	//	(1) to calculate the generated group (insertTransform)
	//  (2) to create a representation of the lattice in this MovieClip. (setSymmetry)
	//  (3) to snap new transforms to their correct positions if they are close
	//      enough to group transforms.
	//
	private var _symmetry:String = "all";
	private var _origin:Vector;	// origin of the lattice in the plane
	var translations:Array;
	var rotations:Array;
	var reflections:Array;
	var glides:Array;
	var fundamentals:Array;
	var _selected:Boolean;
	var grid:Grid;
	var matrix:Matrix;
	var inverseMatrix:Matrix;
	//
	// generator stack - these are transforms in the plane
	//
	var generators:Array;
	//
	// Constants
	//
	//static var INSERT:Number = 0;
	//static var CONFLICT:Number = 1;
	//static var IGNORE:Number = 2;
	//static var PROMOTE:Number = 3;

	public function Group() {
		generators = [];
		matrix = new Matrix();
		inverseMatrix = new Matrix();
		setSymmetry("all");
		_alpha = 30;
	}
	
	public function clear():Void {
			super.clear();		
			translations = [];
			rotations = [];
			reflections = [];
			glides = [];
			for(var i = 0; i < fundamentals.length; i++) {
				var f:MovieClip = MovieClip(fundamentals[i]);
				f.removeMovieClip();
			}
			fundamentals = [];
	}
	
	public function get latticeOrigin():Vector {
		return _origin;
	}
	
	function set selected(b:Boolean):Void {
		_selected = b;
		for(var i:Number; i < transforms.length; i++) {
			var t:Transform = Transform(transforms[i]);
			t.selected = b;
		}
	}
	
	function get selected():Boolean {
		return _selected;
	}
	
	function get symmetry():String {
		return _symmetry;
	}
	
	function toString():String {
		return "Group: " + _symmetry;
	}
	
	
	
	function setSymmetry(s:String, origin:Vector, base0:Vector, base1:Vector):Number {
		var rot:Number = Math.atan2(base0.y, base0.x)*180/Math.PI;
		if(rot==null || isNaN(rot)) {
			rot = 0;
		}
		clear();
		_origin = origin;
		_x = origin.x;
		_y = origin.y;
		trace("setSymmetry("+s+") ");
		switch(s) {
		case "none":
			generators = [];
			matrix.identity();
			inverseMatrix.identity();
			break;
		case "all":
		case "1":
			break;
		case "2":
		case "3":
		case "4":
		case "5":
		case "6":
		case "7":
		case "8":
			//
			// rosette group
			//
			var rotation:Rotation = Rotation(attachMovie("R"+s, "r"+s+"-0", 0, {_x:0, _y:0, order:s}));				
			rotations[0] = rotation;
			trace("rotations[0]="+rotation);
			//matrix.rotate(rotation.radians);
			//inverseMatrix = inverseMatrix.rotate(-rotation.radians);
			break;
		case "22":
			//
			// partially determined 22 group
			//
			translations[0] = Translation(attachMovie("Translation", "t0", 0, {_x:0, _y:0, vector:base0}));
			rotations[0] = Rotation(attachMovie("R2", "r2-0", 1, {_x:0, _y:0, order:2, _rotation:rot}));
			rotations[1] = Rotation(attachMovie("R2", "r2-1", 2, {_x:base0.x, _y:base0.y, order:2, _rotation:rot}));
			matrix.a = base0.x;
			matrix.c = base0.y;
			break;
		case "2222":
			var b0:Vector = base0.times(1/2);
			var b1:Vector = base1.times(1/2);
			var b:Vector = b0.plus(b1);
			translations[0] = Translation(attachMovie("Translation", "t0", 0, {_x:0, _y:0, vector:base0}));
			translations[1] = Translation(attachMovie("Translation", "t1", 1, {_x:0, _y:0, vector:base1}));
			rotations[0] = Rotation(attachMovie("R2", "r2-0", 2, {_x:0, _y:0, order:2, _rotation:rot}));
			rotations[1] = Rotation(attachMovie("R2", "r2-1", 3, {_x:b0.x, _y:b0.y, order:2, _rotation:rot+45}));
			rotations[2] = Rotation(attachMovie("R2", "r2-2", 4, {_x:b1.x, _y:b1.y, order:2, _rotation:rot+90}));
			rotations[3] = Rotation(attachMovie("R2", "r2-3", 5, {_x:b.x, _y:b.y, order:2, _rotation:rot-45}));
			break;
		case "333":
			var base1 = base0.rotate(Math.PI/3);
			var b:Vector = base0.plus(base1);
			var th = b.times(1/3);
			var tth = b.times(2/3);
			translations[0] = Translation(attachMovie("Translation", "t0", 0, {_x:0, _y:0, vector:base0}));
			translations[1] = Translation(attachMovie("Translation", "t1", 1, {_x:0, _y:0, vector:base1}));
			trace("base0 ="+base0 + " base1="+base1);
			rotations[0] = Rotation(attachMovie("R3", "r3-0", 2, {_x:0, _y:0, order:3, _rotation:rot}));
			rotations[1] = Rotation(attachMovie("R3", "r3-1", 3, {_x:th.x, _y:th.y, order:3, _rotation:rot+40}));
			rotations[2] = Rotation(attachMovie("R3", "r3-2", 4, {_x:tth.x, _y:tth.y, order:3, _rotation:rot+80}));
			break;
		case "442":
			var base1:Vector = base0.rotate(Math.PI/2);
			var b:Vector = base0.plus(base1);
			var h0:Vector = base0.times(1/2);
			var h1:Vector = base1.times(1/2);
			var h:Vector = h0.plus(h1);
			translations[0] = Translation(attachMovie("Translation", "t0", 0, {_x:0, _y:0, vector:base0}));
			translations[1] = Translation(attachMovie("Translation", "t1", 1, {_x:0, _y:0, vector:base1}));
			rotations[0] = Rotation(attachMovie("R4", "r4-0", 2, {_x:0, _y:0, order:4, _rotation:rot}));
			rotations[1] = Rotation(attachMovie("R4", "r4-1", 3, {_x:h.x, _y:h.y, order:4, _rotation:rot+45}));
			rotations[2] = Rotation(attachMovie("R2", "r2-0", 4, {_x:h0.x, _y:h0.y, order:2, _rotation:rot}));
			break;			
		case "632":
			var base1:Vector = base0.rotate(Math.PI/3);
			var b:Vector = base0.plus(base1);
			var h = b.times(1/2);
			var h0 = base0.times(1/2);
			var h1 = base1.times(1/2);
			var th = b.times(1/3);
			var tth = b.times(2/3);
			translations[0] = Translation(attachMovie("Translation", "t0", 0, {_x:0, _y:0, vector:base0}));
			translations[1] = Translation(attachMovie("Translation", "t1", 1, {_x:0, _y:0, vector:base1}));
			rotations[0] = Rotation(attachMovie("R6", "r6-0", 2, {_x:0, _y:0, order:6, _rotation:rot}));
			rotations[1] = Rotation(attachMovie("R3", "r3-0", 3, {_x:th.x, _y:th.y, order:3, _rotation:rot}));
			rotations[2] = Rotation(attachMovie("R3", "r3-0", 4, {_x:tth.x, _y:tth.y, order:3, _rotation:(rot+60)}));
			rotations[3] = Rotation(attachMovie("R2", "r2-0", 5, {_x:h0.x, _y:h0.y, order:2, _rotation:rot}));
			rotations[4] = Rotation(attachMovie("R2", "r2-1", 6, {_x:h1.x, _y:h1.y, order:2, _rotation:(rot+120)}));
			rotations[5] = Rotation(attachMovie("R2", "r2-2", 7, {_x:h.x, _y:h.y, order:2, _rotation:(rot-120)}));
			break;
		default:
			trace("symmetry: "+s+" not yet implemented");
			break;
		}
		_symmetry = s;
		setMatrices();
		copyToTransforms();
		trace("transforms.length = " + transforms.length);
		return rot;
	}
	
	public function setMatrices():Void {
		//
		// set up i,j -> base0,base1 map
		//
		matrix = new Matrix(20,0,0,20);
		var base0:Vector = Translation(translations[0]).vector;
		var base1:Vector = Translation(translations[1]).vector;
		trace("setMatrices base0=" + base0 + "  base1 = " + base1);
		if(base0 != null) {
			matrix.a = base0.x;
			matrix.c = base0.y;
		}
		if(base1 != null) {
			matrix.b = base1.x;
			matrix.d = base1.y;
		}
		//
		// and its inverse
		//
		if(_origin != null) {
			matrix.translate(_origin.x, _origin.y);
		}
		inverseMatrix = matrix.clone();
		inverseMatrix.invert();
		//
		// redraw grid for this matrix
		//
		grid.matrix = matrix;
		grid.clear();
		grid.draw();
	}
	
	public function copyToTransforms():Void {
		transforms = [];
		for(var i:Number = 0; i < translations.length; i++) {
			transforms.push(translations[i]);
		}
		for(i = 0; i < rotations.length; i++) {
			transforms.push(rotations[i]);
		}
		for(i = 0; i < glides.length; i++) {
			transforms.push(glides[i]);
		}
		for(i = 0; i < reflections.length; i++) {
			transforms.push(reflections[i]);
		}
	}
	
	public function insertTransform(t:Transform):Number {
		trace("GROUP insertTransform");
		if (t instanceof (Rotation)) {
			insertRotation(Rotation(t));
		}
		if (t instanceof Translation) {
			trace("Translation insertion not implemented");
		}
		return IGNORE;
	}

	/*
		might not need this...
	
	public function rotationGenerators():Array {
		var rots:Array = [];
		for(var i:Number=0; i < generators.length; i++) {
			var t:Transform = Transform(generators[i]) {
				if(t instanceof Rotation) {
					rots.push(t);
				}
			}
		}
		return rots;
	}
	*/
	
	public function insertRotation(r:Rotation):Number {
		if(symmetry == "none") {
			return INSERT;
		}
		//
		// Following is wrong when we allow other kinds of transform...
		//
		var rv:Number;
		trace("generators.length = " + generators.length);
		switch(generators.length) {
		case 0:
			rv = insertFirstRotation(r);
			break;
		case 1:
			rv = insertSecondRotation(r);
			break;
		case 2:
			rv = insertThirdRotation(r);
			break;
		default:
			// Beware - this happens - and the INSERT return is needed!
			rv = INSERT;
		}
		return rv;
	}
	
	public function insertFirstRotation(r0:Rotation):Number {
		switch (symmetry) {
		case "none":
			return INSERT;
		case "1":
		case "all" :
			trace("r0.centre="+r0.centre);
			newGenerator(r0, setSymmetry(""+r0.order, r0.centre));
			return INSERT;
		default:
			setSymmetry("none");
			return INSERT;
		}
	}
	
	public function insertSecondRotation(r1:Rotation):Number {
		var centre:Vector = r1.centre.minus(_origin);
		var r0:Rotation = Rotation(rotations[0]);
		var r0r1:Vector;
		if(r0 != null) {
			if(r0.equals(r1)) {
				if (r1.order % r0.order == 0) {
					return PROMOTE;
				}
				else {
					return CONFLICT;
				}
			}
			r0r1 = centre.minus(r0.centre);
		}
		trace("2nd rotn: r0 = " + r0.centre + " r1 = " + r1.centre + " centre = " + centre + " origin=" + _origin + " r0r1="+r0r1.toString());
		switch (symmetry) {
		case "2" :
			switch(r1.order) {
				case 2:
					base0 = r0r1;
					newGenerator(r1, setSymmetry("22", _origin, r0r1));
					return INSERT;
				case 3:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/2).times(Math.sqrt(3)*2);
					var origin:Vector = _origin.minus(base0.times(1/2));
					newGenerator(r1, setSymmetry("632", origin, base0));
					return INSERT;
				case 4:
					// Define 442 with a single base vector with order 4 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/2).times(2);
					var origin:Vector = _origin.minus(base0.times(1/2));
					newGenerator(r1, setSymmetry("442", origin, base0));
					return INSERT;
				case 6:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.times(-2);
					var origin:Vector = _origin.minus(base0.times(1/2));
					newGenerator(r1, setSymmetry("632", origin, base0));
					return INSERT;
				default:
					setSymmetry("none");
					return INSERT;
			}
			break;
		case "3":
			switch(r1.order) {
				case 2:
					var base0:Vector = r0r1.rotate(Math.PI/2).times(Math.sqrt(3)*2);
					var origin:Vector = r1.centre.minus(base0.times(1/2));
					newGenerator(r1, setSymmetry("632", origin, base0));
					return INSERT;
				case 3:
					var base0:Vector = r0r1; //.times(Math.sqrt(3)).rotate(-Math.PI/6);
					newGenerator(r1, setSymmetry("333", _origin, base0));
					return INSERT;
				case 6:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/6).times(-Math.sqrt(3));
					newGenerator(r1, setSymmetry("632", r1.centre, base0));
					return INSERT;
				default:
					setSymmetry("none");
					return INSERT;
			}
			break;
		case "4":
			switch(r1.order) {
				case 2:
					// Define 442 with a single base vector with order 4 at the origin.
					var base0:Vector = r0r1.times(2);
					newGenerator(r1, setSymmetry("442", _origin, base0));
					return INSERT;
				case 4:
					// Define 442 with a single base vector with order 4 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/4).times(Math.sqrt(2));
					newGenerator(r1, setSymmetry("442", _origin, base0));
					return INSERT;
				default:
					setSymmetry("none");
					return INSERT;
			}
		case "6":
			switch(r1.order) {
				case 2:
					base0 = r0r1.rotate(-Math.PI/6).times(2/Math.sqrt(3));
					newGenerator(r1, setSymmetry("632", _origin, base0));
					return INSERT;
				case 3:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/6).times(Math.sqrt(3));
					newGenerator(r1, setSymmetry("632", _origin, base0));
					return INSERT;
				case 6:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1;
					newGenerator(r1, setSymmetry("632", _origin, base0));
					return INSERT;
				default:
					setSymmetry("none");
					return INSERT;
			}
			break;
		default:
			trace("Sequence: " + r0.order + ":" + r1.order + "not implemented");
			setSymmetry("none");
			return INSERT;
		}
	}
	
	public function insertThirdRotation(r2:Rotation):Number {
		trace("third Rotation");
		var centre:Vector = r2.centre.minus(_origin);
		var r0:Rotation = Rotation(rotations[0]);
		var r1:Rotation = Rotation(rotations[1]);
		var r0r1:Vector = r1.centre.minus(r0.centre);
		var r1r2:Vector = centre.minus(r1.centre);
		var r0r2:Vector = centre.minus(r0.centre);
;
		if(r0 != null && r1 != null) {
			if(r0.equals(r2)) {
				if (r0.order % r0.order == 0) {
					return PROMOTE;
				}
				else {
					return CONFLICT;
				}
			}
			if(r1.equals(r2)) {
				if (r1.order % r1.order == 0) {
					return PROMOTE;
				}
				else {
					return CONFLICT;
				}
			}
		}
		switch (symmetry) {
			case "22" :
				trace("r2.order = " + r2.order);
				switch(r2.order) {
					case 2:
						var base0:Vector = r0r1;
						var base1:Vector = r0r2;
						/*
						  I lose track of the lattice origin doing this...
						// Pick the two shortest vectors as bases
						if(base0.length > base1.length) {
							base0 = base1;
							base1 = r0r1;
						}
						if(base1.length > r1r2.length) {
							base1 = r1r2;
						}
						if(base0.length > base1.length) {
							var tmp = base0;
							base0 = base1;
							base1 = base0;
						}
						*/
						// Check they are sufficiently large vectors
						if(base0.length < 30 || base1.length < 30) {
							return CONFLICT;
						}
						// Check they are sufficiently independent vectors
						var bblen = base0.length * base1.length;
						trace("independence check: " + Math.abs(base0.crozz(base1))/bblen);
						if(Math.abs(base0.crozz(base1))/bblen < 0.5) {
							return CONFLICT;
						}
						// Define 2222 with two base vectors with order 2 at the origin.
						newGenerator(r2, setSymmetry("2222", _origin, base0.times(2), base1.times(2)));
						return INSERT;
					default:
						setSymmetry("none");
						return INSERT;
				}
				break;
			default:
				trace("XXX snap insertion not implemented yet");
				return INSERT;
		}
	}
	
	public function insertRotationOld(r1:Rotation):Number {
		var centre:Vector = r1.centre.minus(_origin);
		var r0:Rotation = Rotation(rotations[0]);
		var r0r1:Vector;
		if(r0 != null) {
			if(r0.equals(r1)) {
				if (r1.order % r0.order == 0) {
					return PROMOTE;
				}
				else {
					return CONFLICT;
				}
			}
			r0r1 = centre.minus(r0.centre);
		}
		switch (symmetry) {
		case "none":
			return INSERT;
		case "1":
		case "all" :
			trace("r1.centre="+r1.centre);
			newGenerator(r1, setSymmetry(""+r1.order, r1.centre));
			return INSERT;
		case "2" :
			case "2" :
			switch(r1.order) {
				case 2:
					base0 = r0r1;
					newGenerator(r1, setSymmetry("22", _origin, r0r1));
					return INSERT;
				case 3:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/2).times(Math.sqrt(3)*2);
					var origin:Vector = _origin.minus(base0.times(1/2));
					newGenerator(r1, setSymmetry("632", origin, base0));
					return INSERT;
				case 4:
				case 6:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.times(-2);
					var origin:Vector = _origin.minus(base0.times(1/2));
					newGenerator(r1, setSymmetry("632", origin, base0));
					return INSERT;
				default:
					setSymmetry("none");
					return INSERT;
			}
			break;
		case "3":
			switch(r1.order) {
				case 2:
					var base0:Vector = r0r1.rotate(Math.PI/2).times(Math.sqrt(3)*2);
					var origin:Vector = r1.centre.minus(base0.times(1/2));
					newGenerator(r1, setSymmetry("632", origin, base0));
					return INSERT;
				case 3:
					newGenerator(r1, setSymmetry("333", _origin, base0));
					return INSERT;
				case 6:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/6).times(-Math.sqrt(3));
					newGenerator(r1, setSymmetry("632", r1.centre, base0));
					return INSERT;
				default:
					setSymmetry("none");
					return INSERT;
			}
			break;

		case "6":
			switch(r1.order) {
				case 2:
					base0 = r0r1.rotate(-Math.PI/6).times(2/Math.sqrt(3));
					newGenerator(r1, setSymmetry("632", _origin, base0));
					return INSERT;
				case 3:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1.rotate(-Math.PI/6).times(Math.sqrt(3));
					newGenerator(r1, setSymmetry("632", _origin, base0));
					return INSERT;
				case 6:
					// Define 632 with a single base vector with order 6 at the origin.
					var base0:Vector = r0r1;
					newGenerator(r1, setSymmetry("632", _origin, base0));
					return INSERT;
				default:
					setSymmetry("none");
					return INSERT;
			}
			break;
		}
		return IGNORE;
	}
	
	
	public function newGenerator(t:Transform, rot:Number):Void {
		generators.push(t);
		trace("GENERATORS: " + generators.length);
		for(var i:Number = 0; i < generators.length; i++) {
			var t:Transform = Transform(generators[i]);
			t._rotation = rot; 
		}
	}
		

	function latticeEquivalent(t:Transform):Transform {
		if(t instanceof Rotation) {
			var tgrid:Vector = grid.inverseImage(t.centre);
			trace("LatticeEquivalent test on " + t._name + " at grid " + tgrid); 
			for(var i = 0; i < rotations.length; i++) {
				var r:Rotation = Rotation(rotations[i]);
				var rgrid:Vector = grid.inverseImage(r.centre.plus(_origin));
				trace("Lattice rotation " + r._name + " at grid " + rgrid); 
//				if(grid.snap(r.centre.plus(_origin)) === v) {
				//if(grid.snap(t.centre) === v) {
					trace("Not equivalent to " + r);
				//}
				//else {
				//	trace("Lattice Equivalent = " + r._name);
				//	return r;
				//}
			}
			trace("No equivalent to " + t + " found");
			return null;
		}
		else {
			trace("latticeEquivalent not implemented for " + t);
		}
	}

	function snapTransform(t:Transform):Transform {
		var centre = t.centre;
		if(translations.length < 2 || translations[0]==null || translations[1]==null) {
			return null;
		}
		//
		// find the transform centre in lattice coordinates
		//
		var lattice:Array = [];
	}
	
	function compatible(t:Transform):Transform {
		for(var i = 0; i < rotations.length; i++) {
			var r = Rotation(rotations[i]);
			var v:Vector = new Vector(t._x-r._x-_origin.x, t._y-r._y-_origin.y);
			if(v.length < Config.snapTolerance) {
			//if(r.hitTest(t._x, t._y, true)) {
				trace("hitTest: " + t._x + "==" + (r._x + _origin.x) + " " + t._y + "==" + (r._y + _origin.y));
				return r;
			}
		}
		return null;
	}
}
