﻿import Config;
import Matrix;
import Vector;
class Grid extends MovieClip {
	var showOffDiagonals:Boolean = false;
	var showLeadDiagonals:Boolean = false;
	var lineThickness = 1;
	var lineColor = 0xCCCCCC;
	var lineAlpha = 100;
	var origin:Vector;
	private var _matrix:Matrix;
	private var _inverseMatrix:Matrix;
	private var _window:MovieClip;
	private var _gridBounds:Object; // bounds in grid coordinates
	private var _depth:Number = 0;
	private var points:Array;
	function Grid() {
		//trace("Grid: this = " + this);
		if(_matrix == null) {
			matrix = new Matrix(20,0,0,20);
		}
		draw();
	}
	function set window(w:MovieClip):Void {
		//trace("set window = " + w);
		_window = w;
		//setMask(_window);
	}
	function get gridBounds():Object {
		//trace("get gridBounds");
		if(_gridBounds == null) {
			if(_window == null) {
				//trace("create window");
				createEmptyMovieClip("window", 1);
				_window = this["window"];
				_window.beginFill(0x880000, 100);
				_window.moveTo(0,0);
				_window.lineTo(Stage.width, 0);
				_window.lineTo(Stage.width, Stage.height);
				_window.lineTo(0, Stage.height);
				_window.lineTo(0, 0);
				_window.endFill();
			}		
			var wb:Object = _window.getBounds();
			wb.xMin += _window._x;
			wb.yMin += _window._y;
			wb.xMax += _window._x;
			wb.yMax += _window._y;
			trace("window bounds = " + wb.xMin + ","+wb.xMax + ":" + wb.yMin + "," + wb.yMax);
			//trace("get gb: matrix = " + _matrix);
			if(_matrix == null) {
				matrix = new Matrix(20,0,0,20);
				_gridBounds = wb;
				return;
			}
			var w00:Vector = inverseImage(new Vector(wb.xMin, wb.yMin));
			var w10:Vector = inverseImage(new Vector(wb.xMax, wb.yMin));
			var w01:Vector = inverseImage(new Vector(wb.xMin, wb.yMax));
			var w11:Vector = inverseImage(new Vector(wb.xMax, wb.yMax));
			_gridBounds = {
				xMin:(Math.floor(min4(w00.x, w10.x, w01.x, w11.x))),
				yMin:(Math.floor(min4(w00.y, w10.y, w01.y, w11.y))),
				xMax:(Math.ceil(max4(w00.x, w10.x, w01.x, w11.x))),
				yMax:(Math.ceil(max4(w00.y, w10.y, w01.y, w11.y)))
			};
			//trace("get _gridBounds = " + _gridBounds.xMin + ","+_gridBounds.xMax + ":" + _gridBounds.yMin + "," + _gridBounds.yMax);
		}
		return _gridBounds;
	}
	function inverseImage(v:Vector):Vector {
		return _inverseMatrix.transformVector(v);
	}
	static private function min4(a:Number, b:Number, c:Number, d:Number):Number {
		//trace("min4:" + a + ":" + b + ":" + c + ":" + d); 
		var r:Number =  Math.min(Math.min(a,b),Math.min(c,d));
		//trace("min = " + r);
		return r;
	}
	static private function max4(a:Number, b:Number, c:Number, d:Number):Number {
		//trace("max4:" + a + ":" + b + ":" + c + ":" + d); 
		var r:Number =  Math.max(Math.max(a,b),Math.max(c,d));
		//trace("max = " + r);
		return r;
	}
	function set matrix(m:Matrix):Void {
		//trace("set matrix = " + m);
		_gridBounds = null;
		_matrix = m.clone();
		_matrix.tx = 0;
		_matrix.ty = 0;
		_inverseMatrix = _matrix.clone();
		_inverseMatrix.invert();
		
		// adjust matrix so tx,ty lies on the grid
		origin = new Vector(m.tx, m.ty);
		var tInvFloor:Vector = inverseImage(origin).round();
		var tFloor:Vector = _matrix.transformVector(tInvFloor);
		_matrix.tx = m.tx - tFloor.x;
		_matrix.ty = m.ty - tFloor.y;
		origin = new Vector(_matrix.tx, _matrix.ty);
		_inverseMatrix = _matrix.clone();
		_inverseMatrix.invert();
		
		// check
		trace("inverse of tx,ty = " + inverseImage(new Vector(_matrix.tx,_matrix.ty)));
		trace("grid matrix = " + _matrix);
		trace("grid inverse = " + _inverseMatrix);
		
	}
	function get matrix():Matrix {
		return _matrix;
	}
	function clear():Void {
		//trace("clear");
		super.clear();
		for(var i = 0; i < texts.length; i++) {
			TextField(texts[i]).removeTextField();
		}
	}
	var texts:Array;
	function draw() {
		// draw lines of constant grid x.
		trace("gridBounds are: ("+gridBounds.xMin + "," + gridBounds.yMin + "):(" + gridBounds.xMax + "," + gridBounds.yMax+")");
		if(isNaN(gridBounds.xMin)) {
			return;
		}
		lineStyle(lineThickness, lineColor, lineAlpha);
		for(var i:Number = gridBounds.xMin; i <= gridBounds.xMax; i++) {
			moveTo(i, gridBounds.yMin);
			lineTo(i, gridBounds.yMax);
			var txt = ""+i;
			if(texts == null) texts = [];
			var tf:TextField = createTextField(txt, getNextHighestDepth(), 0, 0, 100, 20);
			tf.text = txt;
			var v = matrix.transformVector(new Vector(i,(gridBounds.yMax+gridBounds.yMin)/2));
			tf._x = v.x;
			tf._y = v.y;
			texts.push(tf);
		}
		// draw lines of constant grid y.
		for(var j:Number = gridBounds.yMin; j <= gridBounds.yMax; j++) {
			moveTo(gridBounds.xMin, j);
			lineTo(gridBounds.xMax, j);
			if(texts == null) texts = [];
			var txt = ""+j;
			var tf:TextField = createTextField(txt, getNextHighestDepth(), 0, 0, 100, 20);
			tf.text = txt;
			var v = matrix.transformVector(new Vector((gridBounds.xMax+gridBounds.xMin)/2,j));
			tf._x = v.x;
			tf._y = v.y;
			texts.push(tf);
		}
		// draw off diagonals
		for(var sum:Number = gridBounds.xMin + gridBounds.yMin; 
			sum < gridBounds.xMax + gridBounds.yMax; sum++) {
			var v1:Number = Math.min(sum-gridBounds.yMin, gridBounds.xMax);
			moveTo(v1, sum-v1);
			var v2:Number = Math.min(sum-gridBounds.xMin, gridBounds.yMax);
			lineTo(sum-v2, v2);
		}
		/*
		// draw main diagonals
		var diagonals:Boolean = true;
		var xbar:Number = (gridBounds.xMin+gridBounds.xMax)/2;
		var ybar:Number = (gridBounds.yMin+gridBounds.yMax)/2;
		moveTo(xbar, gridBounds.yMin-xbar);
		lineTo(gridBounds.xMax+ybar, ybar);
		moveTo(gridBounds.xMin-ybar, ybar);
		lineTo(xbar, gridBounds.yMax+xbar);
		*/
	}
	function moveTo(x:Number, y:Number):Void {
		var v:Vector = matrix.transformVector(new Vector(x, y));
		super.moveTo(v.x, v.y);
	}
	function lineTo(x:Number, y:Number):Void {
		var v:Vector = matrix.transformVector(new Vector(x, y));
		super.lineTo(v.x, v.y);
	}
	function curveTo(cx:Number, cy:Number, x:Number, y:Number):Void {
		//
		// fortunately parabolas linearly map to parabolas
		//
		var c:Vector = matrix.transformVector(new Vector(cx, cy));
		var v:Vector = matrix.transformVector(new Vector(x, y));
		super.curveTo(c.x, c.y, v.x, v.y);
	}
	//
	// Given a drop point, return the snap point or drop point if we are
	// not close enough to snap.
	//
	function snap(v:Vector, tolerance:Number):Vector {
		if(tolerance == null) {
			tolerance = Config.snapTolerance;
		}
		if(tolerance < 0 || isNaN(tolerance)) {
			return v;
		}
		var g:Vector = _inverseMatrix.transformVector(v).floor();
		var s:Vector = _matrix.transformVector(g);
		//
		// debug
		//
		var gridOrigin:Vector = inverseImage(origin);
		trace("Snapping to " + v + " grid = "+g + " gridImage = " + s + " gridOrigin = " + gridOrigin);
		return (s.minus(v).length <= tolerance) ? s : v;
	}
}