﻿import Toolbox;
import Plane;
import Cursor;
import mx.controls.CheckBox;

class CursorToolbox extends Toolbox {
	var plane:Plane;
	var cursors:Array;
	private var _activeCursor:Cursor = null;

	function CursorToolbox() {
		boxWidth = 130;
		boxHeight = 80;
		activeCursor._visible = false;
	}
	
	public function draw():Void {
		super.draw();
		panel.onBox = onBoxAction;
		panel.offBox = offBoxAction;
		panel.onOffObject = this;
		cursors = [];
		cursors.push(attachMovie("CursorArrow", "normal", 11, {_x:0, _y:0, idName:"CursorArrow"}));
		cursors.push(attachMovie("CursorSelect", "select", 12, {_x:30, _y:0, idName:"CursorSelect"}));
		for(var i = 0; i < cursors.length; i++) {
			var c:Cursor = Cursor(cursors[i]);
			c._x += iconWidth + padding + 10;
			c._y += padding + 10;
			c.toolbox = this;
		}
		minimised = true;
		activeCursor = null;
		//trace("CursorTB Plane = " + plane + " grp= " + plane.group);
	}
	
	public function set activeCursor(c:Cursor):Void {
		//trace("setting activeCursor " + _activeCursor + " = " + c);
		_activeCursor = c;
	}
	
	public function get activeCursor():Cursor {
		return _activeCursor;
	}
	
	public function set minimised(b:Boolean):Void {
		for(var i = 0; i < cursors.length; i++) {
			cursors[i]._visible = !b;
		}
		super.minimised = b;
	}
	
	public function get minimised():Boolean {
		return super.minimised;
	}
	
	function onBoxAction():Void {
		//trace("onBox on "+this);
		activeCursor._visible = false;
		useHandCursor = false;
	}
	
	function offBoxAction():Void {
		//trace("offBox on " + this);
		activeCursor._visible = true;
		useHandCursor = true;
	}
}