﻿class Cursor extends MovieClip {
	var idName:String = "CursorArrow";
	var child:Cursor = null;
	var toolbox:CursorToolbox;
	var r:Number = 15;
	private var _highlighted:Boolean = false;
	
	function Cursor() {
		if(_parent instanceof CursorToolbox) {
			onRelease = toolboxButtonRelease;
			onRollOver = function() {
				toolbox.panel.onBox.call(toolbox.panel.onOffObject);
			}
			onRollOut = function() {
				toolbox.panel.offBox.call(toolbox.panel.onOffObject);
			}
		}
	}
	
	function set active(b:Boolean):Void {
		trace("Cursor " + idName + " active := " + b);
		if(b) {
			//Mouse.hide();
			toolbox.activeCursor = this;
			onMouseMove = mouseMoveAction;
			mouseMoveAction();
		}
		else {
			//Mouse.show();
			toolbox.activeCursor = null;
			onMouseMove = undefined;
			this.removeMovieClip();
		}
	}
	
	function get active():Boolean {
		return onMouseMove != null;
	}
	
	function set highlight(b:Boolean):Void {
		_highlighted = b;
		if(b) {
			beginFill(0xEEEEEE, 100);
		}
		else {
			beginFill(0xDDDDDD, 100);
		}
		//lineStyle(1,0x888888, 100);
		moveTo(-r,-r);
		lineTo(r, -r);
		lineTo(r, r);
		lineTo(-r, r);
		lineTo(-r, -r);
		endFill();
	}
	
	function mouseMoveAction():Void {
		_x = _parent._xmouse;
		_y = _parent._ymouse;
		/*
		if(toolbox.mouseOn()) {
			trace("over toolbox");
			_visible = false;
		}
		else {
			_visible = true;
		}
		*/
		updateAfterEvent();
	}
	
	function toolboxButtonRelease():Void {
		if(child == null) {
			child = Cursor(_root.attachMovie(idName, idName+"Active", 20000, {idName:idName, toolbox:toolbox}));
			child.active = true;
			child._visible = true;
			highlight = true;
		}
		else {
			child.active = false;
			child = null;
			highlight = false;
		}
	}
}