﻿import Cons;
import SymmetryGroup;
import DVector;
import Segment;
/**
 * The SymmetryGroups (note the 's' on the end!) object holds a list
 * of all the groups used in the program (each entry in this list is
 * an instance of the SymmetryGroup (no 's' at the end) class.  The
 * SymmetryGroups class is not meant to be instanced; just refer to
 * its <i>group</i> field and <i>getCount()</i> method.
 *
 * @see SymmetryGroup
 * @see Panorama
 */
class SymmetryGroups {
	
  /**
   * The list of groups
   */
  private var _group:Array = null;
  
  function get group():Array {
	  if(_group == null) {
		    _group = [

			//
			// wallpaper groups
			//
		
			new SymmetryGroup(Cons.GROUP_w2222,
							  "2222",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  2,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  null,
							  null,
							  DVector.array(0.0, 0.0,
										   0.5, 0.0,
										   0.0, 0.5,
										   0.5, 0.5)),
		
			new SymmetryGroup(Cons.GROUP_w333,
							  "333",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  3,
							  DVector.array(1.0, 0.0,
											0.5, 0.5*Cons.ROOT3),
							  null,
							  null,
							  DVector.array(0.0, 0.0,
										   0.5, 0.5/Cons.ROOT3,
										   0.5, -0.5/Cons.ROOT3)),
		
			new SymmetryGroup(Cons.GROUP_w442,
							  "442",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  4,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  null,
							  null,
							  DVector.array(0.0, 0.0,
										   0.5, 0.0,
										   0.5, 0.5)),
		
			new SymmetryGroup(Cons.GROUP_w632,
							  "632",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  6,
							  DVector.array(1.0, 0.0,
											0.5, 0.5*Cons.ROOT3),
							  null,
							  null,
							  DVector.array(0.0, 0.0,
										   0.5, 0.0,
										   0.5, 0.5/Cons.ROOT3)),
		
			new SymmetryGroup(Cons.GROUP_wx2222,
							  "*2222",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  2,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  Segment.array(0.0, 0.0, 0.5, 0.0,
											0.5, 0.0, 0.5, 0.5,
											0.5, 0.5, 0.0, 0.5,
											0.0, 0.5, 0.0, 0.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_wx333,
							  "*333",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  3,
							  DVector.array(1.0, 0.0,
											0.5, 0.5*Cons.ROOT3),
							  Segment.array(0.0, 0.0, 0.5, -0.5/Cons.ROOT3,
											0.5, -0.5/Cons.ROOT3, 0.5, 0.5/Cons.ROOT3,
											0.5, 0.5/Cons.ROOT3, 0.0, 0.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_wx442,
							  "*442",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  4,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  Segment.array(0.0, 0.0, 0.5, 0.0,
											0.5, 0.0, 0.5, 0.5,
											0.5, 0.5, 0.0, 0.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_wx632,
							  "*632",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  6,
							  DVector.array(1.0, 0.0,
											0.5, 0.5*Cons.ROOT3),
							  Segment.array(0.0, 0.0, 0.25, 0.25*Cons.ROOT3,
											0.25, 0.25*Cons.ROOT3, 0.0, 1.0/Cons.ROOT3,
											0.0, 1.0/Cons.ROOT3, 0.0, 0.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_w4x2,
							  "4*2",
							  Cons.AXIS_X4,
							  Cons.AXIS_NONE,
							  4,
							  DVector.array(0.5, 0.5,
											0.5, -0.5),
							  Segment.array(-0.25, 0.25, 0.25, 0.25),
							  null,
							  DVector.array(0.0, 0.0)),
		
			new SymmetryGroup(Cons.GROUP_w3x3,
							  "3*3",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  3,
							  DVector.array(0.5*Cons.ROOT3, 0.5,
											0.0, 1.0),
							  Segment.array(0.0, 0.0, 0.25*Cons.ROOT3, 0.25,
											0.0, 0.0, 0.25*Cons.ROOT3, -0.25),
							  null,
							  DVector.array(1.0/Cons.ROOT3, 0.0)),
		
		
			//	2x22
			//
			// This group is easily defined by a reflection followed by an
			// order two rotation.  The only problem is that the translations
			// are then at odd angles, making it hard to deform the shape of
			// the fundamental domain.  So instead we throw an "unnecessary"
			// glide reflection into the definition: it makes the fundamental
			// domain twice as big, and makes the translations orthogonal to
			// one another.
			//
			// This all makes more sense if you draw a picture.  Start with a
			// rectangle with mirrored edges to represent *2222, and mod out
			// by a half turn about its center to get 2*22.  Bisect the
			// rectangle to get a fundamental domain for the orbifold (I cut
			// it with a diagonal, but any bisection will do).  Mark the
			// origin at the center of the rectangle, and draw a dozen or so
			// of its nearest translates in the universal cover.  Color in
			// your original fundamental domain (half the original rectangle).
			// Then color its reflection in the line x = (width of
			// rectangle)/2.  Then take the union of the two colored regions
			// and color their image under a glide reflection a distance
			// (height of rectangle)/2 along the y-axis.  Finally, take the
			// union of all that and color its image under a half turn about
			// the origin.  Your final colored region will tile the plane
			// under the action of the generators x -> x + 2*width, y -> y +
			// 2*height.  The point of all this is that we can do the initial
			// calculation for a square, and then stretch it after the fact.
			//
			
			new SymmetryGroup(Cons.GROUP_w2x22,
							  "2*22",
							  Cons.AXIS_X4,
							  Cons.AXIS_X0,
							  2,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  Segment.array(0.25, -0.25, 0.25, 0.25,
											-0.25, -0.25, 0.25, -0.25),
							  Segment.array(0.0, 0.0, 0.0, -0.25),
							  DVector.array(0.0, 0.0)),
			
			new SymmetryGroup(Cons.GROUP_w22x,
							  "22*",
							  Cons.AXIS_X4,
							  Cons.AXIS_NONE,
							  2,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  Segment.array(0.25, -0.5, 0.25, 0.5),
							  null,
							  DVector.array(0.0, 0.0,
										   0.0, 0.5)),
		
			new SymmetryGroup(Cons.GROUP_wxx,
							  "**",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  1,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  Segment.array(0.0, -0.5, 0.0, 0.5,
											0.5, -0.5, 0.5, 0.5),
							  null,
							  null),
		
		
			new SymmetryGroup(Cons.GROUP_wxo,
							  "*o",
							  Cons.AXIS_X0,
							  Cons.AXIS_X4,
							  1,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  Segment.array(0.0, 0.0, 0.0, 1.0),
							  Segment.array(0.25, 0.0, 0.25, 0.5),
							  null),
		
			new SymmetryGroup(Cons.GROUP_woo,
							  "oo",
							  Cons.AXIS_NONE,
							  Cons.AXIS_X0,
							  1,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  null,
							  Segment.array(0.0, 0.0, 0.0, 0.5,
											0.5, 0.0, 0.5, 0.5),
							  null),
		
			new SymmetryGroup(Cons.GROUP_w22o,
							  "22o",
							  Cons.AXIS_NONE,
							  Cons.AXIS_X4,
							  2,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  null,
							  Segment.array(0.25, 0.0, 0.25, 0.5),
							  DVector.array(0.0, 0.0,
										   0.0, 0.5)),
		
			new SymmetryGroup(Cons.GROUP_wt,         // torus
							  "0",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  1,
							  DVector.array(1.0, 0.0,
											0.0, 1.0),
							  null,
							  null,
							  null),
		
			//
			// frieze groups
			//
		
			new SymmetryGroup(Cons.GROUP_fii,
							  "oooo",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  1,
							  DVector.array(1.0, 0.0),
							  null,
							  null,
							  null),
		
		
			new SymmetryGroup(Cons.GROUP_fix,
							  "oo*",
							  Cons.AXIS_Y0,
							  Cons.AXIS_NONE,
							  1,
							  DVector.array(1.0, 0.0),
							  Segment.array(0.0, 0.0, 1.0, 0.0),
							  null,
							  null),
		
		
			new SymmetryGroup(Cons.GROUP_fxii,
							  "*oooo",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  1,
							  DVector.array(1.0, 0.0),
							  Segment.array(0.0, -1.0, 0.0, 1.0,
											0.5, -1.0, 0.5, 1.0),
							  null,
							  null),
		
		
			new SymmetryGroup(Cons.GROUP_f22i,
							  "22oo",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  2,
							  DVector.array(1.0, 0.0),
							  null,
							  null,
							  DVector.array(0.0, 0.0,
										   0.5, 0.0)),
		
		
			new SymmetryGroup(Cons.GROUP_fx22i,
							  "*22oo",
							  Cons.AXIS_Y0,
							  Cons.AXIS_NONE,
							  2,
							  DVector.array(1.0, 0.0),
							  Segment.array(0.0, 0.0, 0.5, 0.0,
											0.0, 0.0, 0.0, 1.0,
											0.5, 0.0, 0.5, 1.0),
							  null,
							  null),
		
		
			new SymmetryGroup(Cons.GROUP_f2xi,
							  "2*oo",
							  Cons.AXIS_X4,
							  Cons.AXIS_NONE,
							  2,
							  DVector.array(1.0, 0.0),
							  Segment.array(0.25, -1.0, 0.25, 1.0),
							  null,
							  DVector.array(0.0, 0.0)),
		
		
			new SymmetryGroup(Cons.GROUP_fio,
							  "ooo",
							  Cons.AXIS_NONE,
							  Cons.AXIS_Y0,
							  1,
							  DVector.array(1.0, 0.0),
							  null,
							  Segment.array(0.0, 0.0, 0.5, 0.0),
							  null),
		
			//
			// rosette groups
			//
		
			new SymmetryGroup(Cons.GROUP_r1,
							  "1",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  1,
							  null,
							  null,
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_r2,
							  "2",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  2,
							  null,
							  null,
							  null,
							  DVector.array(0.0, 0.0)),
		
			new SymmetryGroup(Cons.GROUP_r3,
							  "3",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  3,
							  null,
							  null,
							  null,
							  DVector.array(0.0, 0.0)),
		
			new SymmetryGroup(Cons.GROUP_r4,
							  "4",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  4,
							  null,
							  null,
							  null,
							  DVector.array(0.0, 0.0)),
		
			new SymmetryGroup(Cons.GROUP_r5,
							  "5",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  5,
							  null,
							  null,
							  null,
							  DVector.array(0.0, 0.0)),
		
			new SymmetryGroup(Cons.GROUP_r6,
							  "6",
							  Cons.AXIS_NONE,
							  Cons.AXIS_NONE,
							  6,
							  null,
							  null,
							  null,
							  DVector.array(0.0, 0.0)),
		
			new SymmetryGroup(Cons.GROUP_rx1,
							  "*1",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  1,
							  null,
							  Segment.array(0.0, 0.0, 0.0, 1.0,
											0.0, 0.0, 0.0, -1.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_rx2,
							  "*2",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  2,
							  null,
							  Segment.array(0.0, 0.0, 0.0, 1.0,
											0.0, 0.0, 1.0, 0.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_rx3,
							  "*3",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  3,
							  null,
							  Segment.array(0.0, 0.0, 0.0, 1.0,
											0.0, 0.0, 0.0, -1.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_rx4,
							  "*4",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  4,
							  null,
							  Segment.array(0.0, 0.0, 0.0, 1.0,
											0.0, 0.0, 0.5*Cons.ROOT2, 0.5*Cons.ROOT2),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_rx5,
							  "*5",
							  Cons.AXIS_X0,
							  Cons.AXIS_NONE,
							  5,
							  null,
							  Segment.array(0.0, 0.0, 0.0, 1.0,
											0.0, 0.0, 0.0, -1.0),
							  null,
							  null),
		
			new SymmetryGroup(Cons.GROUP_rx6,
							  "*6",
							  Cons.AXIS_X0,
		
							  Cons.AXIS_NONE,
							  6,
							  null,
							  Segment.array(0.0, 0.0, 0.0, 1.0,
											0.0, 0.0, 0.5, 0.5*Cons.ROOT3),
							  null,
							  null)
		
		   ];
	  }
	  return _group;
  }
  
  function SymmetryGroups() {
  }
  
  /**
   * Return the number of groups in the list.
   */
  public function getCount():Number {
    return group.length;
  }

}
