﻿import DVector;
/**
 * A Segment is simply a collection of two DVectors; it's the
 * basic unit of drawing in Kali.
 */
class Segment {

  /**
   * The array of 2 DVectors, which are the endpoints of the
   * segment.
   */
  var p:Array;

  /**
   * Create a new segment from 4 doubles
   */
  public function Segment(x0:Object, y0:Object, x1:Number, y1:Number) {
	  p = [];
	  if(x0 instanceof Number) {
      	p[0] = new DVector(Number(x0),Number(y0));
      	p[1] = new DVector(x1,y1);
	  }
	  else {
		  p[0] = x0;
		  p[1] = y0;
	  }
  }

  /**
   * Return a new segment which is a copy of this one.
   */
  public function copy():Segment {
    return new Segment(p[0].copy(), p[1].copy());
  }

  /**
   * Swap the two endpoints of this segment.
   */
  public function reverse():Void {
    var temp:DVector = p[0];
    p[0] = p[1];
    p[1] = temp;
  }

  /**
   * Convert this segment to a string
   */
  public function toString():String {
    return "{" + p[0] + "," + p[1] + "}";
  }

  /**
   * Construct an array of Segments; the array method takes
   * 4, 8, 12, or 16 doubles, and returns an array of 1,2,3, or
   * 4 Segments, respectively.
   */
  public static function array(x0:Number, y0:Number, x1:Number, y1:Number, 
								x2:Number, y2:Number, x3:Number, y3:Number,
								x4:Number, y4:Number, x5:Number, y5:Number,
								x6:Number, y6:Number, x7:Number, y7:Number):Array {
	var s:Array = [];
	s.push(new Segment(x0, y0, x1, y1));
    if(x2 != null) {
		s.push(new Segment(x2, y2, x3, y3));
	}
    if(x4 != null) {
		s.push(new Segment(x4, y4, x5, y5));
	}
    if(x6 != null) {
		s.push(new Segment(x6, y6, x7, y7));
	}
	return s;
  }


  /**
   * Convert an array of Segments to a string
   */
  public static function aString(s:Array):String {
	var buf:String = "[";
	if (s != null) {
		for (var i:Number=0; i<s.length; ++i) {
			if (i>0) {
				buf += ","; 
			}
			buf += s[i].toString();
	  	}
	}
	buf += "]";
	return buf;
  }

}

