﻿//import java.awt.*;
import DVector;
import DMatrix;
/**
*
* An abstract canvas object which serves the purpose of insulating the
* mathematical part of the program (Panorama object below) from the
* graphics (DrawPanel object above).  The Panorama object does its
* drawing by making calls to the KaliCanvas object, which in turn
* translates them into the appropriate graphics calls for drawing on
* the DrawPanel object.
* 
* <p>
* 
* (It might be more efficient to have the Panorama object make the
* graphics calls directly, but for now we try it this way.)
*
* <p>
* 
* <b>Coordinate systems:</b>
* 
* <p>
* 
* Kali uses 3 different coordinate systems for the image in the DrawPanel:
* 
* <dl>
*     <dt><i>Raw Screen Coordinates</i>
*         <dd>This is the original screen coordinate system of the
* 	    drawing area, which goes from (0,0) in the upper left to
* 	    (screenWidth, screenHeight) in the lower right (in
* 	    pixels).  Y increases DOWN in this system.
* 	    <p>
* 	    Mouse events happen in this coordinate system.
* 	    <p>
* 
*     <dt><i>Screen Coordinates</i>
* 	<dd>This system is the result of translating the raw screen
* 	    system so that (0,0) is at the center of the screen; so it
* 	    goes from (-screenWidth/2, -screenHeight/2) in the upper
* 	    left to (screenWidth/2, screenHeight/2) in the lower
* 	    right.  Y increases DOWN in this system too.
* 	    <p>
* 	    Drawing happens in this coordinate system; the
* 	    KaliCanvas.setGraphics() method calls g.translate() to
* 	    move the Graphics object's origin from the upper left (the
* 	    default) to the center of the screen.  Also, the
* 	    translation computations in the Panorama object happen in
* 	    this system.
* 	    <p>
* 
*       <dt><i>Internal Coordinates</i>
* 	<dd>This system goes from (-internalWidth, internalHeight) in
* 	    the upper left to (internalWidth, -internalHeight) in the
* 	    lower right; so (0,0) is at the center of the screen.  Y
* 	    increases UP in this system.
* 	    <p>
* 	    The coordinates of drawn segments are stored in this
* 	    system.  Also, the Panorama object does some of the group
* 	    action math (reflection and rotation) in this system.
* 	    <p>
* 	    Also, in the future, scaling and translation may be
* 	    implemented by transforming this system.
* 	    <p>
* </dl>
*
* Flash Note: KaliCanvas becomes takes over the role of the Java Graphics class
*
* @see Panorama
* 
*/

class KaliCanvas extends MovieClip {

  /**
  	* Java stuff provided by MovieClip one way or another
	*/
  var screenWidth:Number =400;
  var screenHeight:Number =400;
  var internalWidth:Number =-2.5;
  var internalHeight:Number =2.5;
  var position:DMatrix;
  var positionInverse:DMatrix;
  var screenLeft:Number		= -200;
  var screenRight:Number	=  200;
  var screenBottom:Number	= -200;
  var screenTop:Number		=  200;
  var arrows:Array;

  //Graphics g;
  
  function KaliCanvas() {
    //super();
	screenWidth = _width;
	screenHeight = _height;
	//trace(screenWidth + ":" + screenHeight);
    updateCoordinateSystems();
	arrows = [];
  }
  private function updateCoordinateSystems():Void {
    var xfactor:Number =  2 * internalWidth / screenWidth;
    var yfactor:Number = -2 * internalHeight / screenHeight;
    positionInverse = new DMatrix(xfactor, 0, 0, yfactor);
    position = positionInverse.inverse();
  }
  
  public function rawScreenToInternal(x:Number, y:Number):DVector {
    return positionInverse.timesV(new DVector(x/* - screenWidth/2*/, y/* - screenHeight/2*/));
  }
  
  public function internalToScreen(v:DVector):DVector {
    return position.timesV(v);
  }

  public function drawSegment(s:Segment, rgb:Number):Void {
	lineStyle(1, rgb, 100);
	var sp0:DVector = DVector(s.p[0]);
	var sp1:DVector = DVector(s.p[1]);
	//trace("kCDraw: " + sp0 + " -> " +sp1);
	moveTo((sp0.c[0]+0.5), (sp0.c[1]+0.5));
    lineTo((sp1.c[0]+0.5), (sp1.c[1]+0.5));
  }
  /*
  public function drawBases(bases:Array) {
	  for(var i = 0; i < bases.length; i++) {
	  	var arrow:MovieClip = attachMovie("Arrow", "basis"+i, i);
		var origin:DVector = internalToScreen(new DVector(0,0));
	  	var screenBasis:DVector = internalToScreen(bases[i]);
		arrow._x = origin.c[0];
		arrow._y = origin.c[1];
	  	arrow._width = screenBasis.c[0];
	  	arrow._height = screenBasis.c[1];
	  	arrows[i]=arrow;
	  }
  }
*/
  var basis_mc:MovieClip;
  public function drawBases(bases:Array) {
	  createEmptyMovieClip("b", 0);
	  var b:MovieClip = this["b"];
	  for(var i = 0; i < bases.length; i++) {
		//var origin:DVector = internalToScreen(new DVector(0,0));
	  	//var screenBasis:DVector = internalToScreen(bases[i]).scale(0.02);
		var origin:DVector = new DVector(0,0);
	  	var screenBasis:DVector = bases[i];
		drawArrow(b, origin, screenBasis);
	  }
  }
  public function drawArrow(_mc:MovieClip, origin:DVector, tip:DVector):Void {
	  _mc.lineStyle(5, 0x666666, 50);
	  _mc.moveTo(origin.c[0], -origin.c[1]);
	  _mc.lineTo(tip.c[0], -tip.c[1]);
	  var tipBase:DVector = tip.minus(origin).scale(0.3).minus(tip);
	  var left:DVector = tipBase.copyRotate(-0.5);
	  var right:DVector =  tipBase.copyRotate(0.5);
	  _mc.lineTo(left.c[0], -left.c[1]);
	  _mc.lineTo(right.c[0], -right.c[1]);
  }
  
  public function clear():Void {
	  super.clear();
	  for(var i = 0; i < arrows.length; ++i) {
		  arrows[i].removeMovieClip();
	  }
	  arrows = [];	  
  }
  
  //
  // Following is for test purposes only - access to these calls is hidden by
  // the DrawPanel layer above. Comment out DrawPanel to enable.
  //
  function onPress() {
	  clear();
	  trace("P: "+_xmouse + ":" + _ymouse);
	  var internal:DVector = rawScreenToInternal(_xmouse, _ymouse);
	  trace("internal = "+internal);
	  var screen:DVector = internalToScreen(internal);
	  trace("screen = " + screen);
	  lineStyle(1,0,100);
	  moveTo(_xmouse, _ymouse);
  }
  
  function onRelease() {
	  trace("r "+_xmouse + ":" + _ymouse);
	  lineTo(_xmouse, _ymouse);
  }
}
