﻿//import java.awt.*;
//import java.util.Vector;
/**
 * The DrawPanel object is Kali's actual drawing area.  It receives
 * and handles the mouse events related to drawing, maintains the list
 * of line segments that have been drawn (and their colors), keeps
 * track of whether we're drawing a temporary segment (the segment
 * that follows the mouse during drawing), and if so, its coordinates.
 * <p>
 * The screen is drawn in Kali whenever the system calls the
 * DrawPanel's paint() method; this method goes through the list of
 * current segments, and calls the Panorama's drawSegement() method
 * for each one.
 */
import DVector;
import Segment;
import KaliCanvas;
import Panorama;
import ControlPanel;
class DrawPanel extends MovieClip {
	/**
	   * The lists of segments and their colors
	   */
	var segments:Array;
	var black:Number = 0xff;
	//var colors:Array;
	/**
	   * The endpoints of the temporary line segment, in internal
	   * coordinates.
	   */
	var v1:DVector;
	var v2:DVector;
	/**
	   * Are we drawing a temporary segment?
	   */
	var drawing:Boolean = false;
	/**
	   * Max amount of time, in milliseconds, between the clicks
	   * of a double-click.  (Two clicks within this amount of time
	   * are considered to be a double-click.)  A double-click
	   * ends the current polyline.
	   */
	var doubleClickTime:Number = 400;
	/**
	   * Are we doing double-buffering?  (In general we should,
	   * for flicker-free drawing, but this flag is here so we
	   * can turn it off during testing/debugging if we want).
	   */
	var doublebuffered:Boolean = true;
	/**
	   * ids of the KaliCanvas and Panorama objects that this
	   * DrawPanel relates to.
	   */
	var kaliCanvas:KaliCanvas;
	var panorama:Panorama;
	var controlPanel:ControlPanel;
	
	/**
	   * lastMouseTime records the time at which the last MOUSE_DOWN
	   * event happened; it's used in detecting double clicks.
	   */
	var lastMouseTime:Number = 0;
	/**
	   * lastMouseX and lastMouseY record the (raw) screen coordinates
	   * at which the last MOUSE_DOWN occurred.
	   */
	var lastMouseX:Number = -1000;
	var lastMouseY:Number = -1000;
	/**
	   * closeMouseDistanceSquared is the square of the distance, in
	   * pixels, which is considered "close" for mouse clicks.
	   */
	var closeMouseDistanceSquared:Number = 4;
	/**
	   * Pointer to the offscreen image used for double-buffering.
	   */
	//static Image offscreen;
	/**
	   * Create a new DrawPanel object.
	   * @param panorama	The Panorama object that this DrawPanel
	   *			relates to.
	   * @param kaliCanvas	The KaliCanvas object that this DrawPanel
	   *			relates to.
	   */
	function DrawPanel() {
		segments = [];
		kaliCanvas.setMask(this);
	}
	private function screenDistanceSquared(x1:Number, y1:Number, x2:Number, y2:Number):Number {
		var dx:Number = x1 - x2;
		var dy:Number = y1 - y2;
		return dx * dx + dy * dy;
	}
	/**
	   * Erase the screen and clear the list of segments
	   */
	public function clear():Void {
		segments = [];
		//colors.removeAllElements();
		drawing = false;
		kaliCanvas.clear();
		//repaint();
	}
	function onPress():Void {
		var now:Number = getTimer();
		var doubleClicked:Boolean;
		var mouseClose:Boolean;
		//trace("P");
		doubleClicked = (now - lastMouseTime < doubleClickTime);
		mouseClose = (screenDistanceSquared(_xmouse, _ymouse, lastMouseX, lastMouseY) <= closeMouseDistanceSquared);
		lastMouseX = _xmouse;
		lastMouseY = _ymouse;
		lastMouseTime = now;
		if (drawing) {
			// we drop the line (quit drawing) if either the MOUSE_DOWN event
			// happened within doubleClickTime of the previous one, or if
			// it's considered "close" to the previous one.
			if (doubleClicked || mouseClose) {
				drawing = false;
				repaint();
			}
			else {
				//colors.addElement(getForeground());
				//trace("AGAIN");
				v2 = kaliCanvas.rawScreenToInternal(_xmouse, _ymouse);
				segments.push(new Segment(v1, v2));
				//was v1.copy()
				repaint();
				v1 = v2;
			}
		}
		else {
			// Don't start a line with a double-click
			if (!doubleClicked) {
				v1 = kaliCanvas.rawScreenToInternal(_xmouse, _ymouse);
				drawing = true;
			}
		}
	}
	function onMouseMove():Void {
		if (drawing) {
			v2 = kaliCanvas.rawScreenToInternal(_xmouse, _ymouse);
			kaliCanvas.clear();
			repaint();
		}
	}
	function repaint():Void {
				if(controlPanel.showTranslations()) {
					kaliCanvas.drawBases(panorama.bases());
				}
		if ((segments.length > 0) || drawing) {
			var foreground:Number = black;
			//getForeground();
			//kaliCanvas.setGraphics(g, size().width, size().height);
			if (panorama.prepareToDraw()) {
				for (var i:Number = 0; i < segments.length; i++) {
					var s:Segment = Segment(segments[i]);
					var c:Number = black;
					//Number(colors.elementAt(i));
					panorama.drawSegment(s, c);
				}
				if (drawing) {
					var s:Segment = new Segment(v1, v2);
					//trace("paint: " + s.p[0] + " -> " + s.p[1]);
					panorama.drawSegment(s, foreground);
				}
			}
		}
	}
}
