﻿/**
 * A DVector represents a vector in R2; each coordinate
 * is a double.
 */

class DVector {
  var c : Array;

  /**
   * Create a new DVector with given coordinates.
   */
  function DVector(x:Number, y:Number) {
	c = [];
    c[0] = x==null ? 0 : x;
  	c[1] = y==null ? 0 : y;
  }

  /**
   * Convert a DVector to a String
   */
  function toString():String {
    return "{" + c[0] + "," + c[1] + "}";
  }

  /**
   * Return the length (magnitude) of this DVector (sqrt(x^2 + y^2))
   */
  function length():Number {
    return Math.sqrt( c[0]*c[0] + c[1]*c[1] );
  }

  /**
   * Multiply this vector by -1.
   */
  function negate():DVector {
    c[0] = -c[0];
    c[1] = -c[1];
	return this;
  }

  /**
   * Multiply this vector by the scalar s.
   */
  function scale(s:Number):DVector {
    c[0] *= s;
    c[1] *= s;
	return this;
  }
  
  /**
   * Subtract
   */
   function minus(v:DVector):DVector {
	   c[0] -= v.c[0];
	   c[1] -= v.c[1];
	   return this;
   }

  /**
   * Add
   */
   function plus(v:DVector):DVector {
	   c[0] += v.c[0];
	   c[1] += v.c[1];
	   return this;
   }
   
  /**
   * Rotate
   */
   function copyRotate(radians:Number):DVector {
	   var c = Math.cos(radians);
	   var s = Math.sin(radians);
	   return new DVector(c[0]*c + c[1]*s, -c[0]*s + c[1]*c);
   }

  /**
   * Return the dot product of this vector with another one.
   */
  function dot(v:DVector):Number {
    return c[0]*v.c[0] + c[1]*v.c[1];
  }

  /**
   * Return a copy of this vector.
   */
  function copy():DVector {
    return new DVector(c[0], c[1]);
  }

  /**
   * Construct an array of DVectors; the array method takes
   * 2,4,6, or 8 doubles, and returns an array of 1,2,3, or
   * 4 DVectors, respectively.
   */
   /*
   * JUNK
   */
  public static function array(x0:Number, y0:Number, x1:Number, y1:Number, x2:Number, y2:Number, x3:Number, y3:Number):Array {
	var s:Array = [new DVector(x0, y0)];
	if(x1 != null) {
		s.push(new DVector(x1, y1));
	}
	if(x2 != null) {
		s.push(new DVector(x2, y2));
	}
	if(x3 != null) {
		s.push(new DVector(x3, y3));
	}
	return s;
  }

  /**
   * Convert an array of DVectors to a string.
   */
	public static function aString(v:Array):String {
		var buf:String = "[";
		if (v != null) {
			for (var i:Number=0; i<v.length; ++i) {
				if (i>0) { 
					buf += ", ";
				}
				buf += v[i];
			}
		}
		buf += "]";
		return buf;
	}
	
}

