﻿import DVector;
/**
 * A DMatrix is a 2x2 matrix; each entry is a double.
 */
class DMatrix {
  var c:Array;

  /**
   * Create a new matrix with unspecified entries.
   */
  public function DMatrix(x00:Number, x01:Number, x10:Number, x11:Number) {
	  if(isNaN(x00) || isNaN(x01) || isNaN(x10) || isNaN(x11)) {
		  c = [[1,0],[0,1]];
		  return;
	  }
	  c = [[x00, x01], [x10, x11]];
  }
  
  /**
   * Multiply this matrix by another one. This is RIGHT multiplication:
   * M.times(N) returns M * N.
   */
  public function times(N:DMatrix):DMatrix {
    var result:DMatrix = new DMatrix();
    for (var i:Number=0; i<2; ++i) {
      for (var j:Number=0; j<2; ++j) {
		result.c[i][j] = c[i][0]*N.c[0][j] + c[i][1]*N.c[1][j];
      }
    }
    return result;
  }

  /**
   * Multiply this matrix by a vector on the RIGHT:
   * M.times(v) returns M * v.
   */
  public function timesV(v:DVector):DVector {
    var result:DVector = new DVector();
    result.c[0] = c[0][0]*v.c[0] + c[0][1]*v.c[1];
    result.c[1] = c[1][0]*v.c[0] + c[1][1]*v.c[1];
    return result;
  }

  /**
   * Return the determinant of this matrix.
   */
  public function det():Number {
    return c[0][0]*c[1][1] - c[0][1]*c[1][0];
  }

  /**
   * Return the inverse of this matrix.
   */
  public function inverse():DMatrix {
    var d:Number = det();
    var result:DMatrix = new DMatrix( c[1][1]/d, -c[0][1]/d,
				 -c[1][0]/d,  c[0][0]/d );
    return result;
  }

  /**
   * Convert this matrix to a String.
   */
  public function toString():String {
    return "{{" + c[0][0] + "," + c[0][1] + "},{" + c[1][0] + "," + c[1][1] + "}}";
  }

}
